/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.bean;

import java.sql.Timestamp;
import java.util.ArrayList;

import com.clustercontrol.bean.ValidConstant;

/**
 * ログ転送情報Beanクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class LogTransferInfo
extends Object
implements java.io.Serializable
{
	private static final long serialVersionUID = 4587077032808401207L;

	/** 転送設定ID */
	protected String m_transferId;
	
	/** 説明 */
	protected String m_description;
	
	/** ファシリティパス */
	protected String m_scope;
	
	/** ファシリティID */
	protected String m_facilityId;
	
	/** 転送対象ログファイル情報 */
	protected ArrayList<LogTransferFileInfo> m_fileInfo;
	
	/** 有効/無効 */
	protected int m_valid = ValidConstant.TYPE_VALID;
	
	/** 新規作成日時 */
	protected Timestamp m_regDate;
	
	/** 最終変更日時 */
	protected Timestamp m_updateDate;
	
	/** 新規作成ユーザ */
	protected String m_regUser;
	
	/** 最終変更ユーザ */
	protected String m_updateUser;
	
	public LogTransferInfo() {
	}

	public LogTransferInfo(String id, String description, String scope, String facilityId, ArrayList<LogTransferFileInfo> fileInfo, int valid, Timestamp regDate, Timestamp updateDate, String regUser, String updateUser) {
		m_transferId = id;
		m_description = description;
		m_scope = scope;
		m_facilityId = facilityId;
		m_fileInfo = fileInfo; 
		m_valid = valid;
		m_regDate = regDate;
		m_updateDate = updateDate;
		m_regUser = regUser;
		m_updateUser = updateUser;
	}

	/**
	 * @return m_description を戻します。
	 */
	public String getDescription() {
		return m_description;
	}

	/**
	 * @param m_description 設定する m_description。
	 */
	public void setDescription(String m_description) {
		this.m_description = m_description;
	}

	/**
	 * @return m_facilityId を戻します。
	 */
	public String getFacilityId() {
		return m_facilityId;
	}

	/**
	 * @param id 設定する m_facilityId。
	 */
	public void setFacilityId(String id) {
		m_facilityId = id;
	}

	/**
	 * @return m_scope を戻します。
	 */
	public String getScope() {
		return m_scope;
	}

	/**
	 * @param scope 設定する m_scope。
	 */
	public void setScope(String scope) {
		this.m_scope = scope;
	}

	/**
	 * @return m_regDate を戻します。
	 */
	public Timestamp getRegDate() {
		return m_regDate;
	}

	/**
	 * @param date 設定する m_regDate。
	 */
	public void setRegDate(Timestamp date) {
		m_regDate = date;
	}

	/**
	 * @return m_regUser を戻します。
	 */
	public String getRegUser() {
		return m_regUser;
	}

	/**
	 * @param user 設定する m_regUser。
	 */
	public void setRegUser(String user) {
		m_regUser = user;
	}

	/**
	 * @return m_transferId を戻します。
	 */
	public String getTransferId() {
		return m_transferId;
	}

	/**
	 * @param id 設定する m_transferId。
	 */
	public void setTransferId(String id) {
		m_transferId = id;
	}

	/**
	 * @return m_updateDate を戻します。
	 */
	public Timestamp getUpdateDate() {
		return m_updateDate;
	}

	/**
	 * @param date 設定する m_updateDate。
	 */
	public void setUpdateDate(Timestamp date) {
		m_updateDate = date;
	}

	/**
	 * @return m_updateUser を戻します。
	 */
	public String getUpdateUser() {
		return m_updateUser;
	}

	/**
	 * @param user 設定する m_updateUser。
	 */
	public void setUpdateUser(String user) {
		m_updateUser = user;
	}

	/**
	 * @return m_valid を戻します。
	 */
	public int getValid() {
		return m_valid;
	}

	/**
	 * @param flg 設定する m_valid。
	 */
	public void setValid(int valid) {
		m_valid = valid;
	}

	/**
	 * @return m_fileInfo を戻します。
	 */
	public ArrayList<LogTransferFileInfo> getFileInfo() {
		return m_fileInfo;
	}

	/**
	 * @param info 設定する m_fileInfo。
	 */
	public void setFileInfo(ArrayList<LogTransferFileInfo> info) {
		m_fileInfo = info;
	}
}
