/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/

package com.clustercontrol.nodemap.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 描画に利用するためのノードマップモデル。
 * @since 1.0.0
 */
public class NodeMapModel implements Serializable{
	private static final long serialVersionUID = -6891215951167852724L;

	private final String mapId;
	private final String mapName;
	private final String mapPath;
	private String description;
	private String parentMapId;
	private String bgName = "default";
	
	private HashMap<String, FacilityElement> contents;
	private List<Association> associations;
	
	public NodeMapModel(String parentMapId, String mapId, String mapName, String mapPath){
		this.contents = new HashMap<String, FacilityElement>();
		this.associations = new ArrayList<Association>();
		this.parentMapId = parentMapId;
		this.mapId = mapId;
		this.mapName = mapName;
		this.mapPath = mapPath;
	}

	public String getMapId() {
		return mapId;
	}

	public String getParentMapId() {
		return parentMapId;
	}

	public void setParentMapId(String parentMapId) {
		this.parentMapId = parentMapId;
	}
	
	public FacilityElement[] getContents(){
		return contents.values().toArray(new FacilityElement[contents.size()]);
	}
	
	public void addContent(FacilityElement element){
		this.contents.put(element.getFacilityId(), element);
	}

	public Association[] getAssociations() {
		return associations.toArray(new Association[associations.size()]);
	}
	
	public void addAssociation(Association association){
		this.associations.add(association);
	}
	
	public void removeAssociation(Association association){
		this.associations.remove(association);
	}
	
	public String getMapName() {
		return mapName;
	}

	public String getMapPath() {
		return mapPath;
	}
	
	// 登録済みおよび未登録エレメントの中から指定のファシリティIDのエレメントを返します。
	public FacilityElement getElement(String facilityId){
		FacilityElement element = contents.get(facilityId);
		return element;
	}

	public String getBgName() {
		return bgName;
	}

	public void setBgName(String bgName) {
		this.bgName = bgName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
}
