/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Create content of header menu
 */
(function(__){
	var __hdr   = __.$hdr
	,__layout   = __.$layout
	,hdr_menu_data
	,fns        = ["addView", "createDialog"]
	,fn
	,len        = fns.length
	,cnt
	,validators = []
	,fnDft      = function(){
		return false;
	}
	,bindAction = function($p_a, p_fn_call, p_param){
		$p_a.click(function(e){
			__.hideSubHeader();
			p_fn_call.call(__, p_param);
			e.stopPropagation();
		});
	}
	,createMenu = function($p_parent, p_children){
		var child
		,template = "<li><a><span>#{value}</span></a></li>"
		,$tplt
		,content
		,$ul
		,int_value
		,fn_call
		,param
		;
		
		// p_children must be a object
		if(!((typeof p_children) == "object")){
			return;
		}
		
		// Browse elements
		for(child in p_children){
			$tplt = $(template
				.replace(/#\{value\}/g, child)
			);
			
			// Get conten of LI
			content = p_children[child];
			
			// Check content
			if($.isArray(content)){
				// This is a action (the leaf, not a branch),
				//   It can have parameter
				
				// Set default:
				// Set param is null
				fn_call = fnDft;
				param   = null;
				
				// Check length: it must be 1 or 2 element,
				//   function (position or name) and parameter
				//   parameter can be null
				if((content.length == 1) // the second parameter is not set
					|| ((content.length == 2)
							&& (!(content[1]) || (param = content[1])))){
					
					// Check type of the first element
					if((typeof content[0]) == "number"){
						// Check postion in array
						if((0 <= content[0]) && (content[0] < len)){
							// Get floor value of position
							int_value = Math.floor(content[0]);
							
							// Check valid of function
							if(validators[int_value] === true){
								fn_call = __[fns[int_value]];
							}
						}else{
							}
					}else{
						// This is name of function
						if(((typeof content[0]) != "string")
								|| !(fn_call = __[content[0]])
								|| ((typeof fn_call) != "function")){
							// Set call function default
							fn_call = fnDft;
						}
					}
				}else{
					}
				
				// Bind action for anchor click
				bindAction($tplt.children("a"), fn_call, param);
			}else{
				if((typeof content) == "object"){
					// This is a UL: list of LIs
					$ul = $("<ul></ul>");
					createMenu($ul, content);
					$tplt.append($ul);
				}}
			
			$p_parent.append($tplt);
		}
	}
	;
	
	// Check common functions will bind for link
	for(cnt = 0; cnt < len; cnt++){
		if(fn = __[fns[cnt]]){
			// This function is exist
			validators[cnt] = true;
		}else{
			validators[cnt] = false;
		}
	}
	
	// Check function "getHeaderMenu"
	$.ajax({
		url: "language/common/headerData.js"
		,cache   : false
		,dataType: "script"
		,success : function(){
			var hdr_menu_data = getHeaderData();
			delete getHeaderData;
			
			// Check data
			if((typeof hdr_menu_data) == "object"){
				// Create menu
				createMenu(__hdr, hdr_menu_data);
			}/*
			 * Fix size for header
			 */
			var $uls = __hdr.find("ul")
			,hdr_id  = __hdr.attr("id")
			;
			
			// Set Size for menu elements
			$uls.each(function(){
				var $ul = $(this)
				,width  = 150
				,$lis   = $ul.children("li")
				;
				// Get width max of li
				$lis.each(function(){
					var $a = $(this).children("a:first");
					var w = $a.outerWidth();
					if(width < w){
						width = w;
					}
				});
				
				// Set width of ul is max of width;
				$ul.width(width);
				$lis.width(width);
				
				// Set position from level 2 up
				if($ul.closest("ul").attr("id") != hdr_id){
					$ul.children("li").children("ul").css("left", width);
				}
			});
			
			// Bind action
			__hdr.superfish({delay: 150, sub_delay:1200});
			
			// Toggle "overflow" for menu
			__hdr.children("li").each(function(){
				var $li   = $(this);
				
				// Bind action level 0
				$li.click(function(e){
					if(__hdr.toggleStatus() === true){
						__layout.allowOverflow("north");
					}else{
						__layout.resetOverflow(__hdr);
					}
					
					// Stop action 'hide menu' when click into body
					e.stopPropagation();
				})
				
				// Prevent propagation when click into element Li which is
				//  contains ul
				.find("li:has(ul)").children("a").click(function(e){
					e.stopPropagation();
				});
			});
		}
		,error   : __.loadDataError
	});
})(cm);