/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Declare dialog
 */
(function(__){
	var dialogs = {}
	,dlg_ctrl = {
		/***************************************************
		 * Common properties of perspective
		 */
		/*
		 * Get id of dialog
		 */
		getId: function(dlg_nm){
			return ["#", this._name, "_", dlg_nm].join("");
		}
		
		,/*
		 * Get id of dialog body
		 */
		getBdId: function(dlg_nm){
			return ["bd_", this._name, "_", dlg_nm].join("");
		}
		
		,/*
		 * Get id of dialog body container
		 */
		getCtnId: function(dlg_nm){
			return ["ctn_", this._name, "_", dlg_nm].join("");
		}
		
		,/*
		 * Create dialog
		 */
		createDialog: function(dlg_nm, row_data){
			var _     = this
			,_name    = _._name
			,crt_fn   = __.getFnJs(dlg_nm)
			,dlg      = _[dlg_nm] // dialog control variant
			,content  = {} // Content of dialog
			,$dlg          // Point to this dialog UI
			,dft_opts = {
				autoOpen  : true
				,modal    : true
				,resizable: true
				,title    : _.getTitle(dlg_nm)
			}
			;
			
			// Check view whether to be locked
			if(dlg._lock){
				return;
			}
			
			// Lock dialog
			dlg._lock = true;
			
			// Check whether this is the initializing dialog
			if(dlg._init){
				// Destroy all dialog
				$.extend(dft_opts, {
					close: function(){
						// Destroy
						_.destroyAll();
					}
				});
			}else{
				// Set unlock
				$.extend(dft_opts, {
					close: function(){
						dlg._lock = false;
					}
				});
			}
			
			// Check whether function has been loaded
			if(!(_[crt_fn])){
				// Get function
				$.ajax({
					url      : __.getUrlJs(_name, dlg_nm)
					,cache   : false
					,async   : false
					,dataType: "script"
					,success : function(){
						// Add constructor function for view
						_[crt_fn] = fn;
						delete fn;
					}
					,error   : __.loadDataError
				});
			}
			
			// Check function
			if(!(_[crt_fn])){
				return;
			}
			
			/*
			 * Construct content for dialog
			 */
			// Set template for dialog
			$dlg = $(["<div id='", _.getId(dlg_nm), "' class='dlg-container'></div>"].join(""));
			
			// Initial content
			$.extend(content, _[crt_fn](), {
				$dlg: $dlg
			});
			
			// Append to body
			$dlg.appendTo("body");
			
			$dlg.dialog($.extend(dft_opts, dlg._option, content.getOption()));
			
			// Get HTML
			$.ajax({
				url      : __.getCompLayUrl(_name, dlg_nm)
				,cache   : false
				,dataType: "html"
				,type    : "get"
				,success : function(data_respond){
					var $btns
					,$ctn
					,$bd
					;
					
					// Append data
					$dlg.append(data_respond);
					
					// Set control buttons for this dialog 
					$btns = $dlg.children("div.dlg-btns-container:first");
					
					// Set attributes buttons
					if($btns.length != 0){
						// Get container
						$ctn = $btns.siblings();
						$ctn.attr("id", _.getCtnId(dlg_nm));
						
						// Get body
						$bd = $ctn.children();
						$bd.attr("id", _.getBdId(dlg_nm));
						$bd.$ctn = $ctn;
						
						// Extend content
						$.extend(content, {
							_dir_nm: _name
							,_name : dlg_nm
							,$btns : $btns
							,$bd   : $bd
						});
					}else{
						// Dialog doesn't have buttons on right,
						// Get container
						$ctn = $dlg.children("div");
						$ctn.attr("id", _.getCtnId(dlg_nm));
						
						// Get body
						$bd = $ctn.children();
						$bd.attr("id", _.getBdId(dlg_nm));
						$bd.$ctn = $ctn;
						
						// Cache body
						$.extend(content, {
							_dir_nm: _name
							,_name : dlg_nm
							,$bd   : $bd
						});
					}
					
					// Initialize create content
					content.init(row_data);
					dlg._lock   = false;
					dlg.content = content;
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Open dialog
		 */
		openDialog  : function(dlg_nm, row_data){
			var _ = this
			,dlg
			,dlg_ctt
			;
			
			// Check validation of name
			if(!(dlg = _[dlg_nm])){
				return;
			}
			
			// Check content
			if(dlg_ctt = dlg.content){
				// Open dialog
				dlg_ctt.$dlg.dialog("open");
				
				// Exist data which is necessary to set
				dlg_ctt.loadData(row_data);
				
			}else{
				// Create dialog
				_.createDialog(dlg_nm, row_data);
			}
		}
		
		,/*
		 * Destroy dialog
		 */
		destroyAll  : function(){
			var _ = this
			,dlgs = _._dlgs
			,len  = dlgs.length
			;
			
			while(len--){
				var dlg
				,dlg_nm = dlgs[len]
				,content
				;
				
				// Check to remove dialog and its content
				if(dlg = _[dlg_nm]){
					
					// Delete content
					if(content = dlg.content){
						content.$dlg.dialog("destroy");
						content.$dlg.remove();
						delete dlg.content;
					}
					
					// Unlock dialog
					dlg._lock = false;
				}
			}
		}
	}
	;
	
	/*
	 * Function declare for dialog
	 */
	var declareDialog = function(dir_nm, p_object){
		var dlgs = {}
		,dlg_nms = []
		;
		
		// Check whether name exists
		if(__[dir_nm]){
			return;
		}
		
		// Check object
		if(!(p_object || ((typeof p_object) != "object"))){
			return;
		}
		
		// Store component of
		for(var dlg_nm in p_object){
			var dlg = {}
			,p_dlg  = p_object[dlg_nm]
			;
			
			// Check whether this is the main dialog (the first dialog)
			if(p_dlg.init){
				dlg._init = p_dlg.init;
			}
			
			// Set option
			dlg._option = $.extend({}, p_dlg);
			
			// Set content
			dlgs[dlg_nm] = dlg;
			dlg_nms.push(dlg_nm);
		}
		
		// Constructor for dialog
		$.extend(dlgs, dlg_ctrl, {
			_dlgs    : dlg_nms
			,_name   : dir_nm
			,_lst_ttl: __.getDlgTitle(dir_nm)
			,getTitle: function(key){
				var _    = this
				,lst_ttl = _._lst_ttl
				;
				// Check title
				if(lst_ttl[key]){
					return lst_ttl[key];
				}else{
					return key;
				}
			}
		});
		
		// Declare
		dialogs[dir_nm] = dlgs;
	}
	;
	
	/************************************************************
	 * 1. Hinemos agent
	 */
	declareDialog("hinemosagent", {
		list   : {
			height: 340
			,width: 600
			,init : true
		}
		,modify: {
			height: 500
			,width: 440
		}
	});
	
	/************************************************************
	 * 2. Http
	 */
	declareDialog("http", {
		list   : {
			height: 340
			,width: 600
			,init : true
		}
		,modify: {
			height: 500
			,width: 440
		}
		,string: {
			height: 500
			,width: 440
		}
	});
	
	/************************************************************
	 * 3. LogTransfer
	 */
	declareDialog("logtransfer", {
		list   : {
			height: 340
			,width: 600
			,init : true
		}
		,modify: {
			height: 500
			,width: 440
		}
	});

	/************************************************************
	 * 4. Performance/monitor
	 */
	declareDialog("performance", {
		list   : {
			height: 340
			,width: 600
			,init : true
		}
		,modify: {
			height: 500
			,width: 440
		}
	});
	
	/************************************************************
	 * 5. Ping
	 */
	declareDialog("ping", {
		list   : {
			height: 340
			,width: 600
			,init : true
		}
		,modify: {
			height: 500
			,width: 440
		}
	});
	
	/************************************************************
	 * 6. Process
	 */
	declareDialog("process", {
		list   : {
			height: 340
			,width: 600
			,init : true
		}
		,modify: {
			height: 500
			,width: 440
		}
	});
	
	/************************************************************
	 * 7. SNMP
	 */
	declareDialog("snmp", {
		list   : {
			height: 340
			,width: 600
			,init : true
		}
		,modify: {
			height: 500
			,width: 440
		}
		,string: {
			height: 500
			,width: 440
		}
	});
	
	/************************************************************
	 * 8. SQL
	 */
	declareDialog("sql", {
		list   : {
			height: 340
			,width: 600
			,init : true
		}
		,modify: {
			height: 500
			,width: 440
		}
		,string: {
			height: 500
			,width: 440
		}
	});
	
	/************************************************************
	 * 9. syslogng
	 */
	declareDialog("syslogng", {
		list   : {
			height: 340
			,width: 600
			,init : true
		}
		,modify: {
			height: 500
			,width: 440
		}
	});
	
	/************************************************************
	 * Assign dialog
	 */
	$.extend(__, dialogs);
	
})(cm);