/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



/*******************************************************************************
 * FacilityTree properties (Common data)
 */
/****************************************************************
 * Declare
 */
(function(__){
	var icon_classes = [
		"dynatree-icon-scope"
		,"dynatree-icon-node"
		,"dynatree-icon-composite"
	]
	,TYPE_SCOPE         = 0
	,TYPE_NODE          = 1
	,SCOPE_ICON_DEFAULT = icon_classes[TYPE_NODE]
	;
	
	__.fclt_tree = {
		url             : "get_facility_list"
		,views          : [] // Store views which use facilityTree
		,tree           : {} // Facility Tree
		,type_list      : {} // A list maps to type of facilities
		,reserved_list  : {} // A list contains reserved facilities
		,updateScopeTree: function(){
			try{
				__.repository.scope.content.tree.refreshData(this.get());
			}catch(e){
				}
		}
		,updateTreeViews: function(){
			var _   = this
			,views  = _.views
			,vw_cnt = _.views.length 
			;
			
			while(vw_cnt--){
				var view = views[vw_cnt]
				,pos_sep = view.indexOf("_") // Position of separate
				,per     = view.substr(0, pos_sep)
				,vw      = view.substr(pos_sep + 1)
				,_view   = __[per][vw]
				,content
				;
				
				if((content = _view.content) && (content.resetView)
					&& ((typeof content.resetView ) == "function")) {
					content.resetView(_.get());
				}
			}
			
			return;
		}
		,getDataSucess  : function(data_respond){
			var _ = this
			,tree_data
			;
			
			// Check validation of data_respond
			if(!(cm.checkJsonError(data_respond))){
				return;
			}
			
			if(tree_data = data_respond.facilityTree){
				_.tree = tree_data[0];
				
				// Get tree data
				if(data_respond.typeList){
					_.type_list = data_respond.typeList;
				}
				
				// Get reserved list
				if(data_respond.reservedList){
					_.reserved_list = data_respond.reservedList;
				}
			}else{
				// Process error
				cm.loadDataError();
			}
			
			// Renew getDataSucess
			// This function will be call tree is second load
			_.getDataSucess = function(data_respond){
				var _ = this
				,tree_data
				;
				
				// Check validation of data_respond
				if(!(cm.checkJsonError(data_respond))){
					return;
				}
				
				if(tree_data = data_respond.facilityTree){
					// Check to update data
					_.tree = tree_data[0];
					
					// Get facilityType
					if(data_respond.typeList){
						_.type_list = data_respond.typeList;
					}
					
					// Update tree of repository scope view
					_.updateScopeTree();
					
					// Call update the views which use facilityTree
					_.updateTreeViews();
				}else{
					// Process error
					cm.loadDataError();
				}
			}
		}
		,getData        : function(){
			var _ = this
			;
			
			$.ajax({
				url      : _.url
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					_.getDataSucess(data_respond);
				}
				,error   : cm.loadDataError
			});
		}
		,get            : function(vw_id){
			var _  = this
			,views = _.views
			;
			
			// Set vw_id
			if(vw_id && ((typeof vw_id) == "string")){
				if($.inArray(vw_id, views) == -1){
					views[views.length] = vw_id;
				}
			}
			
			// Return a cloned tree, set the composite is active and expanded
			return $.extend(true, {}, _.tree, {
				activate: true
				,expand : true
			});
		}
		/*
		 * Get class of icon of scope
		 * @param:
		 *   fclt_id : facility id
		 *   opt_rsvd: reserved options
		 */
		,getClassIcon   : function(fclt_id, opt_rsvd){
			var _ = this
			,fclt_txt
			,type
			;
			
			// Check the validation of fclt_id
			if(fclt_id && ((typeof fclt_id) == "string")
					&& ((type = _.type_list[fclt_id]) !== undefined)){
				
				// Check reserved list
				if(opt_rsvd && ((typeof opt_rsvd) == "string")
						&& (type === TYPE_SCOPE)){
					if((fclt_txt = _.reserved_list[fclt_id])
							&& (fclt_txt == opt_rsvd)){
						return SCOPE_ICON_DEFAULT;
					}
				}
				
				if(icon_classes[type]){
					return icon_classes[type];
				};
			}
			
			return SCOPE_ICON_DEFAULT;
		}
	};
	
})(cm);
