/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Inner dialog configuration
 */
(function(__){
	var fn_cm_dlg = {
		/*
		 * Get id (form) of from element
		 */
		ele2Id: function(p_ele){
			return [this._dir_nm, "_", this._name, "_", p_ele].join("");
		}
		
		,/*
		 * Store grid for control data
		 */
		storeGrid: function(grid_nm){
			var _  = this
			,$grid = _.$bd.find(["#", grid_nm].join(""))
			,grids
			;
			
			if(!(grids = _._grids)){
				// Initialize a list storages grids
				grids = _._grids = [];
			}
			
			// Check whether the notify list exits
			if($grid.length){
				// Add to variant which store list of grid
				grids[grids.length] = grid_nm;
				
				// Set id grid again
				$grid.attr("id", _.ele2Id(grid_nm));
				
				// Cache grid content
				_[grid_nm] = $grid;
				return $grid;
			}
			
			return null;
		}
	}
	
	// Declare dialog layout
	$.extend(__, {
		/********************************************************
		 * Dialogs have layout to be grid (Main layout)
		 */
		_fndlg_grid: $.extend({}, fn_cm_dlg, {
			/*
			 * Control size
			 */
			controlSize: function(){
				// Get height of pager
				var _    = this
				,$bd     = _.$bd
				,$bd_ctn = $bd.$ctn
				,w       = $bd_ctn.width()
				,h       = $bd_ctn.height() -
						(
							$("thead:first tr.ui-jqgrid-labels"
									,$bd[0].grid.hDiv).outerHeight(true) // Header
							+$(["#gview_", $bd[0].id, " > div.ui-jqgrid-titlebar"].join("")
									,$bd_ctn).outerHeight(true) // Caption
						);
				
				// Check height
				if(h < 1){
					h = 1;
				}
				
				// Set size of grid
				$bd.setGridWidth(w, false);
				$bd.setGridHeight(h, false);
			}
			
			,/*
			 * Initialize function
			 */
			init: function(){
				var _ = this
				,urls = _.getUrl()
				,$bd  = _.$bd
				,opts
				,dft_opts = {
					datatype      : "json"
					,hidegrid     : false
					,shrinkToFit  : false
					,height       : 1
					,url          : urls.data
					,loadComplete : function(data_respond){
						// Check validation of data_respond
						if(!(__.checkJsonError(data_respond))){
							return;
						}
						
						// Control size when it start
						_.controlSize();
						
						// Bind action for resize dialog
						_.$dlg.bind("dialogresize", function(){
							_.controlSize();
						})
					}
					,loadError    : __.loadDataError
				}
				;
				
				// Get header
				$.ajax({
					url      : urls.header
					,cache   : false
					,dataType: "json"
					,async   : false
					,type    : "get"
					,success : function(data_respond){
						// Check validation of data_respond
						if(!(__.checkJsonError(data_respond))){
							return;
						}
						
						// Set some options for grid
						opts = data_respond;
					}
					,error   : __.loadDataError
				});
				
				// Get data
				$bd = $bd.jqGrid($.extend(dft_opts, opts));
				
				// Bind Action
				_.bindAction();
			}
		})
		
		,/********************************************************
		 * Dialogs not have layout and use remote data
		 */
		_fndlg_html:  $.extend({}, fn_cm_dlg, {
			/*
			 * Get initialed data
			 */
			getDefaultData: function(){
				var _     = this
				,inputs   = _.$bd.find(":input")
				,dft_data = {}
				;
				
				// Set data
				_._dft_data = dft_data;
				
				// Get data
				inputs.each(function(index, ele){
					var input = $(inputs[index]);
					
					dft_data[ele.id] = ele.value;
				});
			}
			
			,/*
			 * Load data
			 */
			loadData: function(row_data){
				var _      = this
				,inform    = _.getUrl()
				,url       = inform.path
				,d_pst_dt  = inform.post_data
				,len       = d_pst_dt.length
				,post_data = {}
				;
				
				if(row_data){
					// Get post data
					while(len--){
						var pst_nm = d_pst_dt[len]; // post name
						if(row_data[pst_nm]){
							post_data[pst_nm] = row_data[pst_nm];
						}
					}
					
					$.ajax({
						dataType: "json"
						,type   : "post"
						,url    : url
						,cache  : false
						,data   : post_data
						,success: function(data_respond){
							// Check validation of data_respond
							if(!(__.checkJsonError(data_respond))){
								return;
							}
							
							// Insert data into inputs
							_.setData(data_respond);
						}
						,error  : __.loadDataError
					});
				}else{
					_.setData();
				}
			}
			
			,/*
			 * 
			 */
			setData: function(data){
				var _   = this
				,inputs = _.$bd.find(":input:not(.select-changeable-options)")
				,data_inputs
				;
				
				// If it doesn't default data, get data default.
				if(data){
					// Not exist 'data' variant, input will be get from default data
					data_inputs = data;
				}else{
					// Get input data
					data_inputs = _._dft_data;
				}
				
				if(_.controlData){
					_.controlData(data_inputs);
				}
				
				// Set input data
				// Set default value
				inputs.each(function(index, ele){
					var input = $(inputs[index])
					,value
					;
					
					if((value = data_inputs[ele.id]) !== undefined){
						var input_type = input.attr("type");
						
						if(input_type == "radio"){
							if(input.val() == value){
								input.attr("checked", "checked")
							}
						}else if(input_type == "checkbox"){
							if(value === true){
								input.attr("checked", true);
							}else{
								input.attr("checked", false);
							}
						}else{
							input.val(value);
						}
					}
				});
				
				var grids = _._grids
				,cnt      = grids.length
				// Set grid data
				while(cnt--){
					var grid_nm = grids[cnt]
					,$grid      = _[grid_nm]
					,grid_data
					;
					
					// Clear old data
					$grid.jqGrid("clearGridData");
					
					// Get new data
					if(grid_data = data_inputs[grid_nm]){
						$grid.setGridParam({data: grid_data});
					}else{
						// Set grid data is null
						$grid.setGridParam({data: []});
					}
					
					// Reload grid
					$grid.trigger("reloadGrid");
				}
				
				// set changeable data
				if(_.setChangeableData){
					_.setChangeableData(data);
				}
			}
			
			,/*
			 * Initialize function
			 */
			init: function(row_data){// Load data
				var _      = this
				,notifies = _.storeGrid("notifies")
				;
				
				// Check whether the notify list exits
				if(notifies){
					notifies = notifies.jqGrid({
						datatype  : "local"
						,height   : 100
						,width    : 250
						,data     : {}
						,hidegrid : false
						,colNames : [__.getLang("notify_id"), __.getLang("notify_type")]
						,colModel : [
							{index : "0", name: "notifyId", width: 120
								,align: "left", sortable: false}
							,{index: "1", name: "notifyType", width: 120
								,align: "left", sortable: false}
						]
					})
				}
				
				// Check whether it's necessary a process data
				if(_.processData){
					_.processData();
				}
				
				// Store default data of form
				_.getDefaultData();
				
				// Load data it need a modification
				if(row_data){
					_.loadData(row_data);
				}
				
				// Bind Action
				_.bindAction();
			}
		})
		
		,/********************************************************
		 * Dialogs not have layout and use remote data
		 */
		_fndlg_string:  $.extend({}, fn_cm_dlg, {
			/*
			 * Load local data
			 */
			loadData: function(data_inputs){
				var _   = this
				,$bd    = _.$bd
				,inputs = $bd.find(":input")
				;
				
				// If it doesn't default data, get data default.
				if(!data_inputs){
					// Close dialog
					_.$dlg.dialog("close");
					return;
				}
				
				/*
				 * TODO
				 */
				// Set input data
				// Set default value
				inputs.each(function(index, ele){
					var input = $(inputs[index])
					,value
					;
					
					if((value = data_inputs[ele.id]) !== undefined){
						var input_type = input.attr("type");
						
						if(input_type == "radio"){
							if(input.val() == value){
								input.attr("checked", "checked")
							}
						}else if(input_type == "checkbox"){
							if(value === true){
								input.attr("checked", true);
							}else{
								input.attr("checked", false);
							}
						}else{
							input.val(value);
						}
					}
				});
				
				// Set grid data
				var grids = _._grids
				,cnt      = grids.length
				while(cnt--){
					var grid_nm = grids[cnt]
					,$grid      = _[grid_nm]
					,grid_data
					;
					
					// Clear old data
					$grid.jqGrid("clearGridData");
					
					// Get new data
					if(grid_data = data_inputs[grid_nm]){
						$grid.setGridParam({data: grid_data});
					}else{
						// Set grid data is null
						$grid.setGridParam({data: []});
					}
					
					// Reload grid
					$grid.trigger("reloadGrid");
				}
				
				// Check whether process if matched
				var $div_proc_mtchd = $bd.find("#div_process_matched:first")
				,value_proc_matchd  = $bd.find("#processType[value=1]")
				;
				
				// Check value
				if(value_proc_matchd.attr("checked")){
					$div_proc_mtchd.find(":input:not(select)").attr("disabled", false);
					$div_proc_mtchd.find("button").attr("disabled", false);
				}else{
					$div_proc_mtchd.find(":input").attr("disabled", true);
					$div_proc_mtchd.find("button").attr("disabled", true);
				}
			}
			
			 /*
			 * Initialize function
			 */
			,init: function(row_data){// Load data
				var _     = this
				,notifies = _.storeGrid("notifies")
				;
				
				// Check whether the notify list exits
				if(notifies){
					notifies = notifies.jqGrid({
						datatype  : "local"
						,height   : 100
						,width    : 250
						,data     : {}
						,hidegrid : false
						,colNames : [__.getLang("notify_id"), __.getLang("notify_type")]
						,colModel : [
							{index : "0", name: "notifyId", width: 120
								,align: "left", sortable: false}
							,{index: "1", name: "notifyType", width: 120
								,align: "left", sortable: false}
						]
					})
				}
				
				// Load data
				_.loadData(row_data);
				
				// Bind Action
				_.bindAction();
			}
		})
	});
})(cm);