/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * HINEMOS formatter for grid data
 */
(function(__) {
	// Formatter data
	var fmt_data

	// Common
	,TREE_ICON_CLASS = "dynatree-icon"

	// Date time
	,DATE_TIME_MARK = "#"
	,date_opts = {
		dayNames   : __.getLang("day_names")
		,monthNames: __.getLang("month_names")
		,AmPm      : ["am", "pm", "AM", "PM"]
	}
	
	// Scope
	,SCOPE_FACILITY_POST     = "pos"
	,SCOPE_FACILITY_RESERVED = "reserved"

	// Priority
	,PRIORITY_CELL_CLASS = "priority-cell"
	,priority_class_list = [
		"priority-critical"
		,"priority-unknown"
		,"priority-warning"
		,"priority-info"
	]

	// Job
	,job_class_list = [
		"dynatree-icon-jobunit"
		,"dynatree-icon-jobnet"
		,"dynatree-icon-job"
		,"dynatree-icon-filejob"
	]
	
	/*
	 * Status list
	 */
	,STATUS_ICON = "status-icon"
	
	// Run status list
	,run_status_list = {
		"0"   : "status-icon-white"  // TYPE_WAIT
		,"1"  : "status-icon-yellow" // TYPE_RESERVING
		,"2"  : "status-icon-yellow" // TYPE_SKIP
		,"100": "status-icon-blue"   // TYPE_RUNNING
		,"101": "status-icon-blue"   // TYPE_STOPPING
		,"200": "status-icon-yellow" // TYPE_SUSPEND
		,"201": "status-icon-red"    // TYPE_STOP
		,"300": "status-icon-green"  // TYPE_END
		,"301": "status-icon-green"  // TYPE_MODIFIED
		,"400": "status-icon-red"    // TYPE_ERROR
	}
	
	// end status_list
	/*
	 * End status list:
	 *   TYPE_NORMAL   : 0
	 *   TYPE_WARNING  : 1
	 *   TYPE_ABNORMAL : 2
	 *   TYPE_BEGINNING: 3
	 */
	,end_status_list = [
		"status-icon-green"
		,"status-icon-yellow"
		,"status-icon-red"
		,"status-icon-white"
	]
	
	/*
	 * Run schedule icon
	 */
	,RUN_SCHEDULE_ICON = "schedule-icon"
	,run_schedule_list = {
		"-1": "schedule-icon-g"
		,"0": "schedule-icon-b"
		,"1": "schedule-icon-w"
	}
	
	/*
	 * Cell contains message which can be showed to more detail
	 */
	,MSG_BTN_CONTAINER = "container-message"
	,MSG_BTN_CLASS      = "btn-in-cell"
	,MSG_BTN_ICON_CLASS = "ui-icon ui-icon-arrowthick-1-ne"
	
	/*
	 * Property 
	 */
	,property_list = {
		checkbox : "hnmCheckbox"
		,datetime: "hnmDatetime"
		,text    : "hnmNonFormat"
		,textarea: "hnmMsgBtn"
	}
	
	;
	
	// Get formatter data
	$.ajax({
		url     : "language/common/formatterData.js",
		cache   : false,
		dataType: "script",
		success : function() {
			fmt_data = getFormatterData();
			delete getFormatterData;
		},
		error   : __.loadDataError
	});

	function pad(value, length) {
		value = String(value);
		length = parseInt(length, 10) || 2;
		while (value.length < length) {
			value = '0' + value;
		}
		return value;
	}
	
	function dateFormat(val, format){
		var token = /\\.|[dDjlNSwzWFmMntLoYyaABgGhHisueIOPTZcrU]/g
		,timezone = /\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g
		,timezoneClip = /[^-+\dA-Z]/g
		,msDateRegExp = new RegExp("^\/Date\\((([-+])?[0-9]+)(([-+])([0-9]{2})([0-9]{2}))?\\)\/$")
		,msMatch = ((typeof date === 'string') ? date.match(msDateRegExp) : null)
		;

		// Check valid of val
		if (!(val && ((typeof val) == "number"))) {
			return "&nbsp;";
		}
		;
		
		// Get format
		if(!(format && ((typeof format) == "string"))){
			format = fmt_data.datetime;
		}
		
		var timestamp = new Date(val);
		var G = timestamp.getHours()
		,i = timestamp.getMinutes()
		,j = timestamp.getDate()
		,n = timestamp.getMonth() + 1
		,o = timestamp.getTimezoneOffset()
		,s = timestamp.getSeconds()
		,u = timestamp.getMilliseconds()
		,w = timestamp.getDay()
		,Y = timestamp.getFullYear()
		,N = (w + 6) % 7 + 1, z = (new Date(Y, n - 1, j) - new Date(Y, 0, 1)) / 86400000
		;

		var flags = {
			// Day
			d : pad(j)
			,D : date_opts.dayNames[w]
			,j : j
			,l : date_opts.dayNames[w + 7]
			,N : N
			//,S : date_opts.S(j)
			/*S: function(j) {
			return j < 11 || j > 13 ? [ 'st', 'nd', 'rd', 'th' ][Math.min(
					(j - 1) % 10, 3)] : 'th'
			}*/
			//,j < 11 || j > 13 ? ['st', 'nd', 'rd', 'th'][Math.min((j - 1) % 10, 3)] : 'th'
			,w : w
			,z : z
			// Week
			,W : N < 5 ? Math.floor((z + N - 1) / 7) + 1 : Math
					.floor((z + N - 1) / 7)
					|| ((new Date(Y - 1, 0, 1).getDay() + 6) % 7 < 4 ? 53 : 52)
			// Month
			,F : date_opts.monthNames[n - 1 + 12]
			,m : pad(n)
			,M : date_opts.monthNames[n - 1]
			,n : n
			,t : '?'
			// Year
			,L : '?'
			,o : '?'
			,Y : Y
			,y : String(Y).substring(2)
			// Time
			,a : G < 12 ? date_opts.AmPm[0] : date_opts.AmPm[1]
			,A : G < 12 ? date_opts.AmPm[2] : date_opts.AmPm[3]
			,B : '?'
			,g : G % 12 || 12
			,G : G
			,h : pad(G % 12 || 12)
			,H : pad(G)
			,i : pad(i)
			,s : pad(s)
			,u : u
			// Timezone
			,e : '?'
			,I : '?'
			,O : (o > 0 ? "-" : "+") + pad(
				Math.floor(Math.abs(o) / 60) * 100 + Math.abs(o) % 60, 4)
			,P : '?'
			,T : (String(timestamp).match(timezone) || [ "" ]).pop().replace(
					timezoneClip, "")
			,Z : '?'
			// Full Date/Time
			,c : '?'
			,r : '?'
			,U : Math.floor(timestamp / 1000)
		};

		return format.replace(token, function($0) {
			return $0 in flags ? flags[$0] : $0.substring(1);
		});
	};
	
	// Format date after that can reverse date precisely
	var hnmDatetimePrecise = function(val) {
		var html  = ""
		,date_str = dateFormat(val);

		if (date_str) { // date_str != ""
			html = [
				date_str
				,"<span style='display:none;'>"
				,DATE_TIME_MARK
				,val
				,"</span>"
			].join("");
		}

		return html;
	}
	hnmDatetimePrecise.unformat = function(cellval) {
		var time_value = 0;

		if (cellval && ((typeof cellval) == "string")) {
			var arr = cellval.split(DATE_TIME_MARK);
			if (arr.length > 1) {
				time_value = arr[1];
			}
		}

		return time_value;
	};

	/*
	 * Confirm type
	 */
	var hnmConfirmed = function(val) {
		var html = "&nbsp;";
		if ((val !== undefined) && (val !== null)
				&& fmt_data.confirmed[val]) {
			html = fmt_data.confirmed[val];
		}
		return html;
	}
	hnmConfirmed.unformat = function(cellval) {
		var value
		,pos
		;
		
		if (cellval && (cellval != "&nbsp;")
				&& ((pos = $.inArray(cellval, fmt_data.confirmed)) != -1)) {
			value = pos;
		}
		return value;
	}

	/*
	 * Format priority cell
	 */
	var hnmPriority = function(val) {
		var c_class, value;

		if ((val === undefined) || ((typeof val) != "number")) {
			return "&nbsp;";
		}

		// Set content
		if (!(c_class = priority_class_list[val])) {
			// Set unknown cell
			c_class = priority_class_list[1];
			value = fmt_data.priority[1];
		} else {
			value = fmt_data.priority[val];
		}

		return [
			"<div class='"
			,PRIORITY_CELL_CLASS
			," "
			,c_class
			,"'>"
			,value
			,"</div>"
		].join("");
	}
	hnmPriority.unformat = function(cellval) {
		var val;
		
		// Check validation
		if (!cellval  || (cellval == "&nbsp;")
				|| ((typeof cellval) != "string")) {
			return null;
		}
		
		// Check "inArray"
		if ((val = $.inArray(cellval, fmt_data.priority)) == -1) {
			return null;
		}
		
		return val;
	}
	
	/*
	 * Format priority cell
	 */
	var hnmSchedule = function(val){
		var date
		,value
		,type
		;
		
		// Chec valid type
		if (!(val && (date = val.date)
				&& ((type = val.type) !== undefined)
				&& ((typeof type) == "number"))){
			return "&nbsp;";
		}
		
		switch(type){
		case 0: // TYPE_EVERY_YEAR
			value = [pad(date.month + 1), "/", pad(date.date), " ", pad(date.hours), ":", pad(date.minutes)].join("");
			break;
		case 1: // TYPE_EVERY_MONTH
			value = [pad(date.date), __.getLang("monthday"), " ", pad(date.hours), ":", pad(date.minutes)].join("");
			break;
		case 2: // TYPE_EVERY_DAY
			value = [pad(date.hours), ":", pad(date.minutes)].join("");
			break;
		case 3: // TYPE_EVERY_HOUR
			value = [date.minutes, __.getLang("minute")].join("");
			break;
		case 4: // TYPE_EVERY_WEEK
			value = [date_opts.dayNames[val.dayOfWeek + 6], " ", pad(date.hours), ":", pad(date.minutes)].join("");
			break;
		default: 
			value = "&nbsp;";
			break;
		}
		
		return value;
	}
	
	// Formatter
	$.extend($.fn.fmatter, {
		hnmNonFormat: function(val){
			return (val ? val : "&nbsp;");
		}
		,/*
		 * Date time
		 */
		hnmDatetime: function(val, format) {
			return dateFormat(val, format);
		}
		,hnmDatetimePrecise: hnmDatetimePrecise

		,/*
		 * Confirmed type
		 */
		hnmConfirmed: hnmConfirmed

		,/*
		 * Scope type
		 */
		hnmScope : function(val, opts, row) {
			var type
			,formatoptions
			,__ = cm
			,fclt_id
			,icon
			;

			// Check null
			if (!(val && row)) {
				return "&nbsp;";
			}
			
			// Check type of row data
			if($.isArray(row)){
				// Check the validation of formatoptions
				if (!(formatoptions = opts.colModel.formatoptions)
						|| (formatoptions[SCOPE_FACILITY_POST] === undefined)){
					return val;
				}

				var pos = formatoptions[SCOPE_FACILITY_POST];
				if (((typeof pos) != "number")
						|| ((fclt_id = row[pos]) === undefined)) {
					return val;
				}
			}else{
				// Get format options
				if (!(formatoptions = opts.colModel.formatoptions)){
					formatoptions = {};
				}
				
				// Get property facilityId
				if(!(fclt_id = row.facilityId)){
					return val;
				}
			}
			
			if(formatoptions[SCOPE_FACILITY_RESERVED] === true){
				icon = __.fclt_tree.getClassIcon(fclt_id, val);
			}else{
				icon = __.fclt_tree.getClassIcon(fclt_id);
			}
			
			return [
				"<span class='"
				,TREE_ICON_CLASS
				," "
				,icon
				,"' ></span>"
				,val
			].join("");
		}
		
		,/*
		 * Priority function
		 */
		hnmPriority : hnmPriority
		
		,/*
		 * Job
		 */
		hnmJob: function(val){
			var c_class, value;
			
			// Chec valid type
			if ((val === undefined) || ((typeof val) != "number")) {
				return "&nbsp;";
			}

			// Set content
			if (!(c_class = job_class_list[val])) {
				// Set unknown cell
				c_class = job_class_list[0];
				value = fmt_data.job[0];
			} else {
				value = fmt_data.job[val];
			}
			
			return [
				"<span class='"
				,TREE_ICON_CLASS
				," "
				,c_class
				,"'></span>"
				,value
			].join("");
		}
		
		,/*
		 * Wait rule
		 */
		hnmWaitRule: function(val){
			var value;
			
			// Chec valid type
			if ((val === undefined) || ((typeof val) != "number")) {
				return "&nbsp;";
			}

			// Check valid content, if ok set value
			if ((value = fmt_data.wait_rule[val]) === undefined){
				return val;
			}

			return value;
		}
		
		,/*
		 * Valid
		 */
		hnmValid: function(val){
			var value;
			
			// Chec valid type
			if ((val === undefined) || ((typeof val) != "number")) {
				return "&nbsp;";
			}

			// Check valid content, if ok set value
			if ((value = fmt_data.valid[val]) === undefined){
				return "&nbsp;";
			}

			return value;
		}
		
		,/*
		 * Schedule
		 */
		hnmSchedule: hnmSchedule
		
		,/*
		 * Run status
		 */
		hnmRunStatus: function(val){
			var c_class, value;
			
			// Chec valid type
			if ((val === undefined) || ((typeof val) != "number")) {
				return "&nbsp;";
			}
			
			// Cash val
			val = String(val);
			
			// Check valid content, if ok set value
			if (!(value = fmt_data.run_status[val])){
				// Set status is error
				value   = fmt_data.run_status["400"];
				c_class = run_status_list["400"];
			}else{
				c_class = run_status_list[val];
			}
			
			return [
				"<span class='"
				,STATUS_ICON
				," "
				,c_class
				,"'></span>"
				,value
			].join("");
		}
		
		,/*
		 * End status
		 */
		hnmEndStatus: function(val){
			var c_class, value;
			
			// Chec valid type
			if ((val === undefined) || ((typeof val) != "number")) {
				return "&nbsp;";
			}
			
			// Check valid content, if ok set value
			if (!(value = fmt_data.end_status[val])){
				// Set status is error
				value   = fmt_data.end_status[3];
				c_class = end_status_list[3];
			}else{
				c_class = end_status_list[val];
			}
			
			return [
				"<span class='"
				,STATUS_ICON
				," "
				,c_class
				,"'></span>"
				,value
			].join("");
		}
		
		,/*
		 * Run schedule
		 */
		hnmRunSchedule: function(val){
			var c_class;
			
			// Chec valid type
			if ((val === undefined) || ((typeof val) != "number")) {
				return "&nbsp;";
			}
			
			// Cash val
			val = String(val);
			
			// Check valid content, if ok set value
			if (!(c_class = run_schedule_list[val])){
				// Set icon is value of after
				c_class = run_schedule_list["1"];
			}
			
			return [
				"<span class='"
				,RUN_SCHEDULE_ICON
				," "
				,c_class
				,"'></span>"
			].join("");
		}
		
		,/*
		 * Cell contains message with content in it
		 */
		hnmMsgBtn: function(val){
			var html;
			// Chec valid type 
			if(!val || ((typeof val) != "string")){
				val = "&nbsp;";
			}else{
				val = val.replace(/\r?\n/g, "<br>")
						.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
			}
			
			html = [
				"<div class='"
				,MSG_BTN_CONTAINER
				,"'><span>"
				,val
				,"</span></div>"
				,"<button style='display:none;' class='"
				,MSG_BTN_CLASS
				,"'><span class='"
				,MSG_BTN_ICON_CLASS
				,"'></span></button>"
			].join("");
			
			return html;
		}
		
		,/*
		 * format check box
		 */
		hnmCheckbox: function(val, option){
			var str_chk = " "
			,icon_check
			;
			
			// Check disable status
			if(option && (option.disabled)){
				// Mode show
				if (val) {
					icon_check = "ui-icon-hnm-checked";
				}else{
					icon_check = "ui-icon-hnm-unchecked";
				}
				
				return __.getIconStr(icon_check)
			}else{
				// Create input: mode create or edit
				if (val) {
					str_chk = " checked='checked' ";
				}
				
				return [
					"<input type='checkbox' value='true'"
					,str_chk
					,">"
				].join("")
			}
		}
		
		,/*
		 * Format field value of property
		 */
		hnmPropertyView: function(val){
			var _ = this
			,type
			,value
			,option
			,fnc
			;
			
			// Check object value
			if(!val || ((typeof val) != "object")){
				return "&nbsp;";
			}
			
			// Check type
			if(!((type = val.type) && ((typeof type) == "string"))){
				return "&nbsp;";
			}
			
			// Get value
			if((val.value !== undefined) && (val.value !== null)){
				value = val.value;
			}else{
				value = ""
			}
			
			// Get option
			if(val.option){
				option = val.option;
			}
			
			// Get function name
			if(!((fnc = property_list[type]) && _[fnc]
					&& ((typeof (_[fnc])) == "function"))){
				return "&nbsp;";
			}
			
			return _[fnc](value, option);
		}
	});

})(cm);