/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create (job management) run schedule
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	var view = $.extend({}, __._fnview_grid_grid, {
		base_date: null
		
		,/*
		 * Set specified period
		 */
		setSpecifiedPeriod: function(){
			var _       = this
			,period_bar = _.rgrid.$pgr.find("td:last")
			,$div = period_bar.find("div:first")
			;
			
			if($div.length == 0){
				$div = $("<div class='container-period'></div>");
				$div.appendTo(period_bar);
			}
			
			if(period_bar.length){
				var str_date = $.fn.fmatter
						.hnmDatetime(_.base_date, __.getLang("period_format"));
				
				$div.html(
					__.getLang("specified_period").replace(/\{0\}/, str_date)
				);
			}
		}
		
		,/*
		 * Update run schedule detail
		 */
		updateRunScheduleDetail: function(schedule_id, jobunit_id){
			var _ = this
			,vw_dtl
			;
			
			// Check whether view "run schedule detail" exists
			if(!(vw_dtl = _pers["run_schedule_detail"])){
				return;
			}
			
			// Update data for view
			vw_dtl.updateData({schedule_id: schedule_id, jobunit_id: jobunit_id});
		}
		
		,/*
		 * Construct for grids
		 */
		createGrids: function(){
			var _     = this
			,datefull = new Date() // getToday
			;
			
			// Set base_date: Only get long value of date
			_.base_date = (
				new Date()
			).getTime();
			
			// Get header of grid
			$.ajax({
				url      : "get_run_schedule_table_defines"
				,cache   : false
				,dataType: "json"
				,type    : "post"
				,data    : {base: _.base_date}
				,success : function(data_respond, textStatus, jqXHR){
					var headers
					,lgrid = _.lgrid
					,lpgr  = lgrid.$pgr
					,rgrid = _.rgrid
					,rpgr  = rgrid.$pgr
					;
					
					// Check validation of default json data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Check validation of content json data_respond
					if(!((headers = data_respond.headers) && $.isArray(headers)
						&& (headers.length == 2))){
						__.loadDataError(jqXHR, textStatus);
						return;
					}
					
					// Set some options for left grid
					var left_header = headers[0];
					$.extend(left_header, {
						datatype       : "local"
						,pager         : lpgr
						,viewrecords   : true
						,scrollCallback: function(){
							var f_grid = _.rgrid
							,scr_top   = this.bDiv.scrollTop
							;
							
							if(f_grid){
								if(scr_top === undefined){
									scr_top = 0;
								}
								f_grid.closest("div.ui-jqgrid-bdiv").scrollTop(scr_top);
							}
						}
						,onSelectRow   : function(row_id){
							var i     = this
							,row_data = $(i).getRowData(row_id)
							;
							_.updateRunScheduleDetail(
								$.jgrid.htmlEncode(row_data.scheduleId)
								,$.jgrid.htmlEncode(row_data.jobunitId)
							);
						}
						,loadComplete: function() {
							// Reload Job[Run Schedule Detail] after Job[Run Schedule] loaded
							var vw_dtl = _pers["run_schedule_detail"];
							if (vw_dtl) {
								var curent_scheduleId   = vw_dtl.__schedule_id;
								var curent_jobunitId = vw_dtl.__jobunit_id;
								
								if (curent_scheduleId !== undefined && curent_scheduleId.length > 0
									&& curent_jobunitId !== undefined && curent_jobunitId.length > 0) {
									var in_runSchedule = _.lgrid.find('tr').filter(function(){
										return ($(this).find('td:first-child').first().text() == curent_scheduleId && 
												$(this).find('td:nth-child(5)').first().text() == curent_jobunitId);
									});
									
									if (in_runSchedule.length > 0) {
										var row_id = $(in_runSchedule[0]).attr('id');
										_.lgrid.jqGrid('setSelection',row_id);
									} else {
										_.updateRunScheduleDetail('', '');
									}
								}
							}
						}
					});
					
					lgrid.processData(left_header);
					lgrid.controlSize();
					
					// Set some options for right grid
					var right_header = headers[1];
					$.extend(right_header, {
						datatype       : "local"
						,pager         : rpgr
						,scrollCallback: function(){
							var f_grid = _.lgrid
							,scr_top   = this.bDiv.scrollTop
							;
							
							if(f_grid){
								if(scr_top === undefined){
									scr_top = 0;
								}
								f_grid.closest("div.ui-jqgrid-bdiv").scrollTop(scr_top);
							}
						}
					});
					
					rgrid.processData(right_header);
					rgrid.controlSize();
					
					// Call function processing data for grid
					_.refreshGrids();
					_.setSpecifiedPeriod();
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Construct for grids
		 */
		refreshGrids: function(ldate){
			var _   = this
			,lgrid  = _.lgrid
			,rgrid  = _.rgrid
			,update = false
			,check_value
			;
			
			// Check ldate
			if(ldate && ((typeof ldate) == "number") && (ldate != _.base_date)){
				// Case update
				update = true;
				
				// Renew base_date
				_.base_date = ldate;
				_.setSpecifiedPeriod();
			}else{
				ldate = _.base_date;
			}
			
			// Clear grids data
			lgrid.clearGridData();
			rgrid.clearGridData();
			
			// Get data of grids
			$.ajax({
				url      : "get_run_schedule_data"
				,cache   : false
				,dataType: "json"
				,type    : "post"
				,data    : {
					updateHeader: update
					,base       : ldate
				}
				,success : function(data_respond, textStatus, jqXHR){
					var left_data
					,right_data
					,col_names
					;
					
					if ((check_value = cm.checkJsonError(data_respond))
						=== false){
						return;
					}
						
					// Check check_value
					if(check_value === true){
						// Check validation of data
						if(!((left_data = data_respond.leftData)
							&& (right_data = data_respond.rightData))){
							__.loadDataError(jqXHR, textStatus);
							return;
						}
						
						// Reload data for left grid
						lgrid.setGridParam({
							data: left_data
						}).trigger("reloadGrid");
						
						// Reload data for left grid
						rgrid.setGridParam({
							data: right_data
						}).trigger("reloadGrid");
						
						// Check for update header of left pane
						if(update){
							// Update header
							if(data_respond.userdata
									&& !$.isEmptyObject(data_respond.userdata)){
								if((col_names = data_respond.userdata.colNames)
									&& $.isArray(col_names)){
									var count = col_names.length;
									while(count--){
										rgrid.jqGrid(
											"setLabel"
											,["column", count].join("_")
											,col_names[count]
										);
									}
								}
							}
						}
					}
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _  = this
			,_btns = _.$btns
			;
			
			// Bind update grid data
			_btns.children("#update").click(function(){
				// Verify role
				_.refreshGrids();
			});
			
			// Bind filter
			_btns.children("#filter").click(function(){
				// Verify role
				__.openCalendar(_, _.refreshGrids);
			});
			
			// Bind toggle left pane
			_btns.children("#toggle_view").click(function(){
				_.togglePane("east", this);
			});
		}
	});
	
	return view;
};