/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create monitor scope
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	 var view = $.extend({}, __._fnview_grid, {
		facility_id: ""
		,load_flg    : false
		,/*
		 * Update data when click on view 'node' content
		 */
		updateData: function(){
			var _ = this;
			if (!(_.load_flg)) {
				_.load_flg = true;
				_.reloadGrid();
				
			}
		}
		,/*
		 * reload data when click on view 'node' content
		 */
		reloadGrid: function(){
			var _        = this 
			,facility_id = _view.__facility_id
			,grid        = _.grid
			;
			
			// Case updating
			_.facility_id = facility_id;
			
			// Reload grid
			grid.refreshData({facilityId: facility_id});
		}
			
		,/*
		 * Get scope list
		 */
		createGrid: function(){
			var _ = this
			,grid = _.grid
			,option = {
				url           : "get_node_property"
				,datatype     : "json"
				,postData     : {
					facilityId: _.facility_id
				}
				,treeGridModel: "adjacency"
				,treeGrid     : true
				,ExpandColumn : "name"
				,treeIcons    : {
					plus  :"ui-icon-hnm-plus"
					,minus:"ui-icon-hnm-minus"
					,leaf :"ui-icon-hnm-none"
				}
				,colNames     : ["id", __.getLang("name"), __.getLang("value")]
				,colModel     : [
					{index : "0", name: "id", width: 15, key: true, hidden: true}
					,{index: "1", name: "name", width: 180, align: "left", classes: "dlg-name-property", sortable: false}
					,{index: "2", name: "value", width: 180, align: "left", sortable: false, formatter: "hnmPropertyView"}
				]
				,gridComplete: function(){
					var $gr = $(this);
					$gr.find("button.btn-in-cell").each(function(){
						$(this).click(function(e){
							var $i = $(this)
							,$div  = $i.siblings("div:first")
							,$title = $i.parent().siblings("td:visible:first")
							;
							
							if($div.length != 0){
								__.openTextDlg({
									content: __.replaceUrlWithHtmlLinks($div.children("span:first").html(), true)
									,title : $title.attr('title')
								});
							}
							
							e.stopPropagation();
						});
					});
					
					$gr.find("div.container-message").each(function(){
						$(this).click(function(e){
							var $i = $(this)
							,$btn  = $i.siblings("button:first")
							;
							
							$btn.css("display", "inline-block")
								.addClass("btn-display-marker");
						});
					});
				}
				, loadComplete: function() {
					var facility_id = _view.__facility_id;
					
					if(facility_id === _.facility_id){
						_.load_flg = false;
					}else{
						setTimeout(function(){
							_.reloadGrid();
						}, 1);
					}
				}
			};
			
			_.grid.processData(option);
			_.grid.controlSize();
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _     = this;
			var _btns = _.$btns;
			
			// Bind actions for button in left of pane
			// Bind update grid data
			_btns.children("#update").click(function(){
				_.grid.refreshData();
			});
		}
	});
	
	return view;
};