/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.bean;

import java.util.Locale;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ実行契機のタイプの定数を定義するクラス
 */
public class JobTriggerTypeConstant {
	/** スケジュール */
	private static final int TYPE_SCHEDULE = 1;
	/** 手動実行 */
	private static final int TYPE_MANUAL = 2;
	/** 監視連動 */
	private static final int TYPE_MONITOR = 3;
	/** スケジュール（文字列） */
	private static final String STRING_SCHEDULE_EN = WebMessages.getString("schedule", Locale.ENGLISH);
	private static final String STRING_SCHEDULE_JP = WebMessages.getString("schedule", Locale.JAPAN);
	/** 手動実行（文字列） */
	private static final String STRING_MANUAL_EN = WebMessages.getString("trigger.manual", Locale.ENGLISH);
	private static final String STRING_MANUAL_JP = WebMessages.getString("trigger.manual", Locale.JAPAN);
	/** 監視連動（文字列） */
	private static final String STRING_MONITOR_EN = WebMessages.getString("trigger.monitor", Locale.ENGLISH);
	private static final String STRING_MONITOR_JP = WebMessages.getString("trigger.monitor", Locale.JAPAN);
	/** 監視連動（文字列） */
    private static final String STRING_UNKNOWN_EN = WebMessages.getString("unknown", Locale.ENGLISH);
    private static final String STRING_UNKNOWN_JP = WebMessages.getString("unknown", Locale.JAPAN);
    
	/**
	 * 種別から文字列に変換する
	 * 
	 * @param type
	 * @return
	 */
	public static String typeToString(int type, Locale locale) {
		if (type == TYPE_SCHEDULE) {
		    if (locale.equals(Locale.ENGLISH)) {
		        return STRING_SCHEDULE_EN;
		    } else {
		        return STRING_SCHEDULE_JP;
		    }
		} else if (type == TYPE_MANUAL) {
		    if (locale.equals(Locale.ENGLISH)) {
                return STRING_MANUAL_EN;
            } else {
                return STRING_MANUAL_JP;
            }
		} else if (type == TYPE_MONITOR) {
		    if (locale.equals(Locale.ENGLISH)) {
                return STRING_MONITOR_EN;
            } else {
                return STRING_MONITOR_JP;
            }
		} else{
		    if (locale.equals(Locale.ENGLISH)) {
                return STRING_UNKNOWN_EN;
            } else {
                return STRING_UNKNOWN_JP;
            }
		}
	}

	/**
	 * 文字列から種別に変換する
	 * 
	 * @param type
	 * @return
	 */
	public static int stringToType(String string) {
		if (string.equals(STRING_SCHEDULE_EN) || string.equals(STRING_SCHEDULE_JP)) {
			return TYPE_SCHEDULE;
		} else if (string.equals(STRING_MANUAL_EN) || string.equals(STRING_MANUAL_JP)) {
			return TYPE_MANUAL;
		} else if (string.equals(STRING_MONITOR_EN) || string.equals(STRING_MONITOR_JP)) {
			return TYPE_MONITOR;
		}
		return -1;
	}
}
