/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.bean;

import java.util.Locale;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * 実行状態の定数クラス<BR>
 * 
 * @version 1.0.0
 * 
 */
public class StatusConstant {
    /** 待機(状態の種別) */
    private static final int TYPE_WAIT = 0;

    /** 保留中(状態の種別) */
    private static final int TYPE_RESERVING = 1;

    /** 実行中(状態の種別) */
    private static final int TYPE_RUNNING = 100;

    /** 停止処理中(状態の種別) */
    private static final int TYPE_STOPPING = 101;

    /** コマンド停止(状態の種別) */
    private static final int TYPE_STOP = 201;

    /** 終了(状態の種別) */
    private static final int TYPE_END = 300;

    /** 変更済(状態の種別) */
    private static final int TYPE_MODIFIED = 301;
    
    /** 待機(状態の種別)（文字列）*/
    private static final String STRING_WAIT_EN = WebMessages.getString("wait", Locale.ENGLISH);
    private static final String STRING_WAIT_JP = WebMessages.getString("wait", Locale.JAPAN);
    
    /** 保留中(状態の種別) （文字列）*/
    private static final String STRING_RESERVING_EN = WebMessages.getString("reserving", Locale.ENGLISH);
    private static final String STRING_RESERVING_JP = WebMessages.getString("reserving", Locale.JAPAN);
    
    /** 実行中(状態の種別) （文字列）*/
    private static final String STRING_RUNNING_EN = WebMessages.getString("running", Locale.ENGLISH);
    private static final String STRING_RUNNING_JP = WebMessages.getString("running", Locale.JAPAN);
    
    /** 停止処理中(状態の種別) （文字列）*/
    private static final String STRING_STOPPING_EN = WebMessages.getString("stopping", Locale.ENGLISH);
    private static final String STRING_STOPPING_JP = WebMessages.getString("stopping", Locale.JAPAN);
    
    /** コマンド停止(状態の種別) （文字列）*/
    private static final String STRING_STOP_EN = WebMessages.getString("stop.at.once", Locale.ENGLISH);
    private static final String STRING_STOP_JP = WebMessages.getString("stop.at.once", Locale.JAPAN);
    
    /** 終了(状態の種別) （文字列）*/
    private static final String STRING_END_EN = WebMessages.getString("end", Locale.ENGLISH);
    private static final String STRING_END_JP = WebMessages.getString("end", Locale.JAPAN);
    
    /** 変更済(状態の種別) （文字列）*/
    private static final String STRING_MODIFIED_EN = WebMessages.getString("modified", Locale.ENGLISH);
    private static final String STRING_MODIFIED_JP = WebMessages.getString("modified", Locale.JAPAN);
   
    
    /**
     * 文字列から種別に変換する
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_RUNNING_EN) || string.equals(STRING_RUNNING_JP)) {
            return TYPE_RUNNING;        //実行中(状態の種別)
        } else if (string.equals(STRING_END_EN) || string.equals(STRING_END_JP)) {
            return TYPE_END;            //終了(状態の種別)
        } else if (string.equals(STRING_WAIT_EN) || string.equals(STRING_WAIT_JP)) {
            return TYPE_WAIT;           //待機(状態の種別)
        } else if (string.equals(STRING_STOPPING_EN) || string.equals(STRING_STOPPING_JP)) {
            return TYPE_STOPPING;       //停止処理中(状態の種別)
        } else if (string.equals(STRING_STOP_EN) || string.equals(STRING_STOP_JP)) {
            return TYPE_STOP;           //コマンド停止(状態の種別)
        } else if (string.equals(STRING_RESERVING_EN) || string.equals(STRING_RESERVING_JP)) {
            return TYPE_RESERVING;      //保留中(状態の種別)
        } else if (string.equals(STRING_MODIFIED_EN) || string.equals(STRING_MODIFIED_JP)) {
            return TYPE_MODIFIED;       //変更済(状態の種別)
        }
        return -1;
    }
}