/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.common;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.ScopeTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.form.GridForm;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.json.GridHeaderJson;
import com.necsoft.hinemos.webclient.json.TreeGridJson;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

/**
 * HTMLに関する処理を定義する共有クラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class DataProcess {

    /**
     * 文字列をHEXに交換する
     * 
     * @param 文字列
     * @return HEX文字列
     */
    public static final String stringToHex(String strInput) {
        if ((strInput == null) || (strInput.equals("")))
            return "";

        int length = strInput.length();
        StringBuffer result = new StringBuffer();
        for (int pos = 0; pos < length; pos++) {
            int this_char = (int) strInput.charAt(pos);
            for (int digit = 0; digit < 4; digit++) {
                int this_digit = this_char & 0xf000;
                this_char = this_char << 4;
                this_digit = (this_digit >> 12);
                if (this_digit >= 10)
                    result.append((char) (this_digit + 87));
                else
                    result.append((char) (this_digit + 48));
            }
        }
        return result.toString();
    }

    public static final Map<String, Object> getRowFromProperty(Property property) {
        return getRowFromProperty(property, JsConstant.TREEGRID_ROOT_LEVEL);
    }

    public static final Map<String, Object> getRowFromProperty(
            Property property, int level) {
        Map<String, Object> data = new HashMap<String, Object>();
        Property proParent;

        // Declare component of data (Default value is ROOT)
        String id;
        String name;
        String value = HtmlEncode.SPACE;
        String parent = JsConstant.TREEGRID_ROOT_PARENT;
        Boolean isLeaf = false;
        Boolean expanded = false;

        // Get id, name
        id = property.getID();
        name = property.getName();

        // Get value
        String propValue = "";
        if (property.getValue() != null) {
            propValue = property.getValue().toString();
        }

        if ((property.getChildren() == null)
                || (property.getChildren().length < 1)) {
            // This is a leaf which doesn't have any child
            isLeaf = true;
            StringBuffer buf = new StringBuffer();

            // Set value properly
            if ((property.getSelectValues() != null)
                    && (property.getSelectValues().length > 0)) {
                // This is a select box
                Object[][] selectContent = property.getSelectValues();

                // Append select
                buf.append("<select class='");
                buf.append(CssClass.GRID_INPUT_SELECT);
                buf.append("' id='");
                buf.append(id);
                buf.append("'>");

                // Append options
                if (selectContent.length > 1) {
                    Object[] selValues = selectContent[0];
                    Object[] selDisplays = selectContent[1];
                    int selLen = selValues.length;
                    if (selDisplays.length == selLen) {
                        for (int cnt = 0; cnt < selLen; cnt++) {
                            buf.append("<option value='");
                            buf.append(selValues[cnt].toString());
                            buf.append("'");

                            // Check selected
                            if (selValues[cnt].toString().equals(propValue)) {
                                buf.append(" selected='selected'");
                            }

                            buf.append(">");
                            buf.append(selDisplays[cnt].toString());
                            buf.append("</option>");
                        }
                    }
                }

                buf.append("</select>");
            } else {
                // This is a input text
                buf.append("<input type='text' id='");
                buf.append(id);
                buf.append("' class='");

                String editor = property.getEditor().toString();

                // Check type value of input text
                if (editor.equals(PropertyClass.DATETIME_EDITOR)) {
                    // This is a datetime input
                    buf.append(CssClass.GRID_INPUT_DATETIME);
                    buf.append("' readonly='readonly");
                } else if (editor.equals(PropertyClass.JOBID_EDITOR)) {
                    buf.append(CssClass.GRID_INPUT_JOBID);
                    buf.append("' readonly='readonly");
                } else {
                    buf.append(CssClass.GRID_INPUT_NORMAL);
                    buf.append("' value='");
                    buf.append(propValue);
                }

                buf.append("'/>");

                if (editor.equals(PropertyClass.JOBID_EDITOR)) {
                    buf.append("<button class='");
                    buf.append(CssClass.GRID_INNER_BUTTON_OPEN_TREE_JOB);
                    buf.append("'/>");
                }
            }

            value = buf.toString();
        }

        // Get parent property
        proParent = (Property) property.getParent();
        if (proParent.getID() != null) {
            parent = proParent.getID();
        }

        // Create array
        data.put("id", id);
        data.put("name", name);
        data.put("value", value);
        data.put("level", level);
        data.put("parent", parent);
        data.put("isLeaf", isLeaf);
        data.put("expanded", expanded);

        return data;
    }

    /**
     * string html escape
     * 
     * @param list
     *            : ArrayList<?>
     * @return ArrayList
     */
    public static final ArrayList stringEscape(ArrayList<?> list) {
        ArrayList lst = new ArrayList();
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i) != null) {
                ArrayList arrayList = (ArrayList) list.get(i);
                ArrayList arrayListRsl = new ArrayList();
                for (int j = 0; j < arrayList.size(); j++) {
                    if (arrayList.get(j) != null) {
                        arrayListRsl.add(StringEscapeUtils.escapeHtml(arrayList
                                .get(j).toString()));
                    }
                }
                lst.add(arrayListRsl);
            }
        }
        return lst;
    }

    /**
     * This method used for convert header of grid to JSON data.
     * 
     * @param tblDefine
     *            : ArrayList<TableColumnInfoJs>
     * @param recordsFlag
     *            : boolean
     * @return GridHeaderJson
     */
    public static final GridHeaderJson doConvertToJson(
            ArrayList<TableColumnInfoJs> tblDefine, boolean recordsFlag,
            Locale locale) {
        // Create JSON
        GridHeaderJson result = new GridHeaderJson();
        result.setColNames(ConvertListUtil.columnInfoToColNames(tblDefine));
        result.setColModel(ConvertListUtil.columnInfoToColModel(tblDefine));

        result.setRowNum(Constants.MONITOR_SCOPE_ROW_NUM);
        result.setSortname(ScopeTableDefine.SORT_COLUMN_INDEX);
        result.setSortorder(SortOrderUtil
                .getJsString(ScopeTableDefine.SORT_ORDER));
        if (recordsFlag) {
            result.setRecordtext(WebMessages.getString("records",
                    new Object[] { "{1}" }, locale));
            result.setEmptyrecords(WebMessages.getString("records",
                    new Object[] { "0" }, locale));
        }
        return result;
    }

    /**
     * This method used for convert data row of grid to JSON data.
     * 
     * @param tblDefine
     *            : ArrayList<?>
     * @return GridDataJson
     */
    public static final GridDataJson doConvertToJson(
            ArrayList<ArrayList> listInfoData) {
        // Create JSON
        GridDataJson result = new GridDataJson();

        // Set rows
        for (int countRow = 0; countRow < listInfoData.size(); countRow++) {
            ArrayList infoData = listInfoData.get(countRow);
            result.addRow(infoData, String.valueOf(countRow + 1));
        }

        // Set other content
        result.setRecords(listInfoData.size());
        return result;
    }

    /**
     * This method used for convert data row of grid to TreeGridJson data.
     * 
     * @param tblDefine
     *            : ArrayList<?>
     * @return GridDataJson
     */
    public static final TreeGridJson doConvertToJson(Property propertyInfo) {

        // Create JSON
        TreeGridJson result = new TreeGridJson();
        Object[] propertiesL0 = propertyInfo.getChildren();
        int lengtL0 = propertiesL0.length;

        // Create data
        for (int cntL0 = 0; cntL0 < lengtL0; cntL0++) {
            Property propertyL0 = (Property) propertiesL0[cntL0];
            // Set data row
            result.addData(DataProcess.getRowFromProperty(propertyL0));
            Object[] propertiesL1 = propertyL0.getChildren();
            if ((propertiesL1 != null) && (propertiesL1.length > 0)) {
                int lengtL1 = propertiesL1.length;
                for (int cntL1 = 0; cntL1 < lengtL1; cntL1++) {
                    Property propertyL1 = (Property) propertiesL1[cntL1];
                    result.addData(DataProcess
                            .getRowFromProperty(propertyL1, 1));
                }
            }
        }
        return result;
    }

    /**
     * This method used for sort data of grid.
     * 
     * @param form
     *            : GridForm
     * @param listInfoData
     *            : ArrayList<?>
     * @param sortColumnIndex
     *            : int
     * @param sortOrder
     *            : int
     * @param iMaxColValue
     *            : int
     * @return void
     */
    public static final void sortData(GridForm form, ArrayList<?> listInfoData,
            int sortColumnIndex, int sortOrder, int iMaxColValue) {

        if (form.getSidx() != null && !("").equals(form.getSidx().trim())) {
            if (Integer.valueOf(form.getSidx()) < iMaxColValue) {
                sortColumnIndex = Integer.valueOf(form.getSidx());
            }
        }
        if (form.getSord() != null && !("").equals(form.getSord().trim())) {
            sortOrder = SortOrderUtil.getSerInt(form.getSord());
        }

        // データをソート
        Collections.sort(listInfoData, new CommonTableViewerSorter(
                sortColumnIndex, -1, sortOrder));
    }

    /**
     * Get time Today
     */
    public static Date getToDay() {
        Calendar calendar = Calendar.getInstance();
        Date today = new GregorianCalendar(calendar.get(Calendar.YEAR),
                calendar.get(Calendar.MONTH),
                calendar.get(Calendar.DAY_OF_MONTH)).getTime();
        return today;
    }
    
    public static final int getViewerSchedule(Date date, Date today) {
        // 中間変数を宣言
        SimpleDateFormat m_formatter = new SimpleDateFormat(
                                             Constants.DATE_YYYY_MM_DD);
        // Set time is 00:00:00 for compare
        date = m_formatter.parse(m_formatter.format(date),
                                                new ParsePosition(0));
        return date.compareTo(today);
    }
}
