/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.common;

/**
 * Define java class
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class JsConstant {

    /*
     * Grid property
     */
    public final static int GRID_MAX_ROW_NUM = 5000;

    public static final String GRID_COL_NAMES = "colNames";

    public static final String PREFIX_NAME_COLUMN_DEFAULT = "column_";

    public static final String GRID_MODEL_INDEX = "index";

    public static final String GRID_MODEL_NAME = "name";

    public static final String GRID_MODEL_WIDTH = "width";

    public static final String GRID_MODEL_ALIGN = "align";

    public static final String GRID_MODEL_HIDDEN = "hidden";

    public static final String GRID_MODEL_SORTABLE = "sortable";

    public static final String GRID_MODEL_KEY = "key";

    public static final String GRID_MODEL_CLASSES = "classes";

    public static final String GRID_MODEL_FORMATTER = "formatter";

    public static final String GRID_MODEL_SORT_TYPE = "sorttype";

    public static final String GRID_MODEL_FORMAT_OPTIONS = "formatoptions";

    // Formatter of jgrid
    public static final String GRID_FMATTER_DATE_TIME = "hnmDatetime";

    public static final String GRID_FMATTER_DATE_TIME_PRECISE = "hnmDatetimePrecise";

    public static final String GRID_FMATTER_CONFIRM_TYPE = "hnmConfirmed";

    public static final String GRID_FMATTER_SCOPE_TYPE = "hnmScope";

    public static final String GRID_FMATTER_SCOPE_TYPE_POSITION = "pos";

    public static final String GRID_FMATTER_SCOPE_TYPE_RESERVED = "reserved";

    public static final String GRID_FMATTER_PRIORITY = "hnmPriority";

    public static final String GRID_FMATTER_JOB = "hnmJob";

    public static final String GRID_FMATTER_WAIT_RULE = "hnmWaitRule";

    public static final String GRID_FMATTER_VALID = "hnmValid";

    public static final String GRID_FMATTER_SCHEDULE = "hnmSchedule";

    public static final String GRID_FMATTER_RUN_STATUS = "hnmRunStatus";

    public static final String GRID_FMATTER_END_STATUS = "hnmEndStatus";

    public static final String GRID_FMATTER_RUN_SCHEDULE = "hnmRunSchedule";

    public static final String GRID_FMATTER_MSG_BTN = "hnmMsgBtn";

    // Tree grid
    public static final String TREEGRID_ROOT_PARENT = "NULL";

    public static final int TREEGRID_ROOT_LEVEL = 0;

    public static final boolean TREE_LOADED = true;

    // Tree grid with local data
    public static final String TREE_GRID_KEY_COLUMN_NAME = "keyColumnJs";

    public static final String TREEGRID_ROOT_PARENT_ID = "";

    public static final String TREEGRID_LOCAL_NODEID = "nodeid";

    public static final String TREEGRID_LOCAL_PARENTID = "parentid";

    public static final String TREEGRID_LOCAL_DATA = "data";

    /*
     * Property
     */
    // public static final String PROPERTY_TYPE_SELECT = "select";

    // public static final String PROPERTY_TYPE_PATH = "brows";

    // public static final String PROPERTY_TYPE_PASSWORD = "password";

    // public static final String PROPERTY_TYPE_FACILITY = "facility";

    public static final String PROPERTY_TYPE_TEXT = "text";

    public static final String PROPERTY_TYPE_TEXTAREA = "textarea";

    public static final String PROPERTY_TYPE_BOOL = "checkbox";

    // public static final String PROPERTY_TYPE_DATE = "date";

    public static final String PROPERTY_TYPE_DATETIME = "datetime";

    // public static final String PROPERTY_TYPE_TIME = "time";

    // public static final String PROPERTY_TYPE_NUM = "num";

    // public static final String PROPERTY_TYPE_JOB = "job";

    // public static final String PROPERTY_TYPE_PING_STATUS = "ping_status";

    // public static final String PROPERTY_TYPE_VERSION = "version";

    // public static final String PROPERTY_TYPE_IPV4 = "ipv4";

    // public static final String PROPERTY_TYPE_IPV6 = "ipv6";

    /*
     * Elements of messages
     */
    public static final String MESSAGE_TITLE = "title";

    public static final String MESSAGE_CONTENT = "content";

    /**
     * @param index
     * @return
     */
    public static String getColNameValue(int index) {
        return PREFIX_NAME_COLUMN_DEFAULT + index;
    }
}