/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.JobInfoNotFoundException;
import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.bean.JobHistoryList;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.util.PropertyUtil;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebJobInfoNotFoundException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.util.EjbConnectionManager;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobPropertyUtil;

/**
 * ジョブ[履歴]ビューの一覧情報を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、履歴一覧情報を取得します。
 * 
 */
public class GetHistory {
    // ----- instance メソッド ----- //
    // namingContextを定義
    private NamingContext m_namingContext = null;

    /**
     * namingContextを設定
     * 
     *@param namingContext
     *@return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_namingContext = namingContext;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、履歴一覧情報を取得します。
     * 
     * @param histories
     *            表示履歴数
     * @return ジョブ履歴一覧情報
     * @throws HinemosWebException
     * 
     * @see com.clustercontrol.jobmanagement.ejb.session.JobController
     * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
     * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean
     *      #getHistoryList(int)
     */
    public JobHistoryList getHistory(int histories) throws HinemosWebException {
        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        JobController job = ejbConnectionManager.getJobController();

        JobHistoryList list = null;
        try {
            list = job.getHistoryList(histories);
        } catch (AccessException e) {
            // アクセス権なしの場合、エラーダイアログを表示する
            throw new HinemosWebAccessException(
                    "exception.job.history.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException("exception.job.history.action", e);
        } catch (JobInfoNotFoundException e) {
            throw new HinemosWebJobInfoNotFoundException("exception.job.history.notfound", e);
        } catch (HinemosUnknownException e) {
            throw new HinemosWebException("exception.job.history.action", e);
        }

        return list;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * フィルタ条件に一致する履歴一覧情報を取得する
     * 
     * @param property
     *            フィルタ条件
     * @param histories
     *            表示履歴数
     * @return ジョブ履歴一覧情報
     * @throws HinemosWebException
     * 
     * @see com.clustercontrol.jobmanagement.ejb.session.JobController
     * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
     * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean
     *      #getHistoryList(com.clustercontrol.bean.Property, int)
     */
    public JobHistoryList getHistory(Property property, int histories)
            throws HinemosWebException {
        PropertyUtil.deletePropertyDefine(property);

        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        JobController job = ejbConnectionManager.getJobController();

        JobHistoryList list = null;
        try {
            list = job.getHistoryList(JobPropertyUtil
                    .property2jobHistoryFilter(property), histories);
        } catch (AccessException e) {
            // アクセス権なしの場合、エラーダイアログを表示する
            throw new HinemosWebAccessException(
                    "exception.job.history.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException("exception.job.history.action", e);
        } catch (JobInfoNotFoundException e) {
            throw new HinemosWebJobInfoNotFoundException("exception.job.history.notfound", e);
        } catch (HinemosUnknownException e) {
            throw new HinemosWebException("exception.job.history.action", e);
        }

        return list;
    }
}