/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.jobmanagement.bean.RunScheduleListTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[実行予定]ビューの左側のテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、左側のテーブル定義を取得する
 * 
 */
public class GetRunScheduleListTableDefine {

    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * ジョブ[実行予定]ビューの左側のテーブル定義を取得する
     * 
     * @return テーブル定義情報 （{@link com.clustercontrol.bean.TableColumnInfoJs}のリスト）
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        // テーブル定義配列
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();
        // Locale locale = Locale.getDefault();

        tableDefine
                .add(
                        RunScheduleListTableDefine.SCHE_ID,
                        new TableColumnInfoJs(
                                WebMessages.getString("schedule.id", locale),
                                TableColumnInfoJs.NONE,
                                80,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getRunScheduleListName(RunScheduleListTableDefine.SCHE_ID),
                                false));
        tableDefine
                .add(
                        RunScheduleListTableDefine.SCHE_NAME,
                        new TableColumnInfoJs(
                                WebMessages.getString("schedule.name", locale),
                                TableColumnInfoJs.NONE,
                                150,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getRunScheduleListName(RunScheduleListTableDefine.SCHE_NAME),
                                false));
        tableDefine
                .add(
                        RunScheduleListTableDefine.JOB_ID,
                        new TableColumnInfoJs(
                                WebMessages.getString("job.id", locale),
                                TableColumnInfoJs.NONE,
                                80,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getRunScheduleListName(RunScheduleListTableDefine.JOB_ID),
                                false));
        tableDefine
                .add(
                        RunScheduleListTableDefine.JOB_NAME,
                        new TableColumnInfoJs(
                                WebMessages.getString("job.name", locale),
                                TableColumnInfoJs.NONE,
                                150,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getRunScheduleListName(RunScheduleListTableDefine.JOB_NAME),
                                false));
        tableDefine
                .add(
                        RunScheduleListTableDefine.JOBUNIT_ID,
                        new TableColumnInfoJs(
                                WebMessages.getString("jobunit.id", locale),
                                TableColumnInfoJs.NONE,
                                100,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getRunScheduleListName(RunScheduleListTableDefine.JOBUNIT_ID),
                                false));
        tableDefine
                .add(
                        RunScheduleListTableDefine.CALENDAR_ID,
                        new TableColumnInfoJs(
                                WebMessages.getString("calendar.id", locale),
                                TableColumnInfoJs.NONE,
                                80,
                                SWT.LEFT,
                                JobMappingUtil
                                        .getRunScheduleListName(RunScheduleListTableDefine.CALENDAR_ID),
                                false));
        /*
         * tableDefine.add(RunScheduleListTableDefine.CALENDAR_ID + 1, new
         * TableColumnInfoJs("", TableColumnInfoJs.CHECKBOX, 0, SWT.LEFT,
         * JobMappingUtil.getRunScheduleListName(
         * RunScheduleListTableDefine.CALENDAR_ID + 1), false));
         */

        return tableDefine;
    }
}