/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.jobmanagement.bean.JobDetailTableDefine;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidDataException;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetJobDetail;
import com.necsoft.hinemos.webclient.jobmanagement.form.JobDetailForm;
import com.necsoft.hinemos.webclient.json.GridDataJson;

/**
 * This class used for get header list
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetJobDetailBusiness {

    // FIXME: Same GetJobDetailTableDefineBusiness

    /**
     * Get header list
     * 
     * @param namingContext
     *            : NamingContext
     * @param form
     *            : JobDetailForm
     * @return List<CommonTableTreeItem>
     * @throws HinemosWebException
     */
    public List<CommonTableTreeItem> doLoadListInfoData(JobDetailForm form,
            NamingContext namingContext) throws HinemosWebException {

        GetJobDetail getJobDetail = new GetJobDetail();
        getJobDetail.setNamingContext(namingContext);
        CommonTableTreeItem treeTable = null;
        treeTable = getJobDetail.getJobDetail(form.getSessionId());

        return Arrays.asList(treeTable.getChildren());
    }

    /**
     * Convert data to JSON structure
     * 
     * @param form
     *            : JobDetailForm
     * @param listItem
     *            : List<CommonTableTreeItem>
     * @return GridDataJson
     * @throws HinemosWebException
     * @throws HinemosWebInvalidNumberSizeDataException
     */
    public GridDataJson doConvertToJson(JobDetailForm form,
            List<CommonTableTreeItem> listItem) throws HinemosWebException {
        GridDataJson result = new GridDataJson();
        generateSerializedData(result, form, listItem,
                JsConstant.TREEGRID_ROOT_LEVEL, JsConstant.TREEGRID_ROOT_PARENT);

        return result;
    }

    /**
     * Generate Serialized Data
     * 
     * @param result
     *            : GridDataJson
     * @param form
     *            : JobDetailForm
     * @param listItem
     *            : List<CommonTableTreeItem>
     * @throws HinemosWebException
     */
    private void generateSerializedData(GridDataJson result,
            JobDetailForm form, List<CommonTableTreeItem> listItem, int level,
            String parentId) throws HinemosWebException {

        boolean isLeaf;

        for (int count = 0; count < listItem.size(); count++) {
            CommonTableTreeItem item = listItem.get(count);
            if (item.getChildren().length != 0) {
                isLeaf = false;
            } else {
                isLeaf = true;
            }

            // Add data
            result.addRow(doConvertTableTreeItemToArray(item, level, parentId,
                    isLeaf));

            // Generate children data
            if (!isLeaf) {
                String jobIdEncode;
                jobIdEncode = DataProcess.stringToHex(item.getData()
                        .get(JobDetailTableDefine.JOB_ID).toString());

                List<CommonTableTreeItem> listChild = Arrays.asList(item
                        .getChildren());
                generateSerializedData(result, form, listChild, level + 1,
                        jobIdEncode);
            }
        }
    }

    /**
     * Convert Tree Item to Array
     * 
     * @param treeTable
     *            : CommonTableTreeItem
     * @param level
     *            : Integer
     * @param parentId
     *            : String
     * @param isLeaf
     *            : boolean
     * @return ArrayList
     * @throws HinemosWebException
     */
    private List<Object> doConvertTableTreeItemToArray(
            CommonTableTreeItem treeTable, int level, String parentIdEncode,
            boolean isLeaf) throws HinemosWebException {

        // Create JSON
        List<Object> result = new ArrayList<Object>();
        ArrayList<Object> data = treeTable.getData();

        String jobId;
        String jobName;
        String jobunitId;
        String facilityId;
        String scope;
        Long startRerunTime;
        Long endSuspendTime;
        String jobIdEncode;

        // Check jobId
        if (data.get(JobDetailTableDefine.JOB_ID) == null) {
            throw new HinemosWebInvalidDataException(
                    "exception.job.jobdetail.jobid.null");
        } else {
            jobId = data.get(JobDetailTableDefine.JOB_ID).toString();

            jobIdEncode = DataProcess.stringToHex(jobId);

            // Escape HTML "jobId"
            jobId = StringEscapeUtils.escapeHtml(jobId);
        }

        // Check jobName
        if (data.get(JobDetailTableDefine.JOB_NAME) == null) {
            jobName = null;
        } else {
            jobName = StringEscapeUtils.escapeHtml(data.get(
                    JobDetailTableDefine.JOB_NAME).toString());
        }

        // Check jobunitId
        if (data.get(JobDetailTableDefine.JOBUNIT_ID) == null) {
            jobunitId = null;
        } else {
            jobunitId = StringEscapeUtils.escapeHtml(data.get(
                    JobDetailTableDefine.JOBUNIT_ID).toString());
        }

        if (data.get(JobDetailTableDefine.START_RERUN_TIME) == null) {
            startRerunTime = null;
        } else {
            startRerunTime = ((Date) data
                    .get(JobDetailTableDefine.START_RERUN_TIME)).getTime();
        }

        if (data.get(JobDetailTableDefine.END_SUSPEND_TIME) == null) {
            endSuspendTime = null;
        } else {
            endSuspendTime = ((Date) data
                    .get(JobDetailTableDefine.END_SUSPEND_TIME)).getTime();
        }

        // Check facilityId
        if (data.get(JobDetailTableDefine.FACILITY_ID) == null) {
            facilityId = null;
        } else {
            facilityId = StringEscapeUtils.escapeHtml(data.get(
                    JobDetailTableDefine.FACILITY_ID).toString());
        }

        // Check scope
        if (data.get(JobDetailTableDefine.SCOPE) == null) {
            scope = null;
        } else {
            scope = StringEscapeUtils.escapeHtml(data.get(
                    JobDetailTableDefine.SCOPE).toString());
        }

        result.add(JobDetailTableDefine.TREE,
                data.get(JobDetailTableDefine.TREE));
        result.add(JobDetailTableDefine.STATUS,
                data.get(JobDetailTableDefine.STATUS));
        result.add(JobDetailTableDefine.END_STATUS,
                data.get(JobDetailTableDefine.END_STATUS));
        result.add(JobDetailTableDefine.END_VALUE,
                data.get(JobDetailTableDefine.END_VALUE));
        result.add(JobDetailTableDefine.JOB_ID, jobId);
        result.add(JobDetailTableDefine.JOB_NAME, jobName);
        result.add(JobDetailTableDefine.JOBUNIT_ID, jobunitId);
        result.add(JobDetailTableDefine.JOB_TYPE,
                data.get(JobDetailTableDefine.JOB_TYPE));
        result.add(JobDetailTableDefine.FACILITY_ID, facilityId);
        result.add(JobDetailTableDefine.SCOPE, scope);
        result.add(JobDetailTableDefine.WAIT_RULE_TIME,
                data.get(JobDetailTableDefine.WAIT_RULE_TIME));
        result.add(JobDetailTableDefine.START_RERUN_TIME, startRerunTime);
        result.add(JobDetailTableDefine.END_SUSPEND_TIME, endSuspendTime);

        // Add properties for tree grid
        result.add(jobIdEncode); // Add key for row
        result.add(level);
        result.add(parentIdEncode);
        result.add(isLeaf);
        result.add(true);
        result.add(JsConstant.TREE_LOADED);

        return result;
    }
}