/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.clustercontrol.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetHistoryFilterPropertyBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.TreeGridJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for get History Property
 * 
 * @version 1.0
 * @since 2011/12/14
 **/
public class GetHistoryFilterPropertyServlet extends CommonServlet {
    private static final long serialVersionUID = -3131350422822624183L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetHistoryFilterPropertyServlet.class);

    /**
     * Get History Property
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     */
    public CommonJson process(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

        CommonJson result = new CommonJson();

        try {
            // 中間変数を宣言
            Property propertyHistory = doLoadProperty(request.getLocale());
            // Create JSON
            result = doLoadDataJson(propertyHistory);

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }

        return result;
    }

    /**
     * Get History Property
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @return Property
     * @throws HinemosWebRemoteException
     */
    private Property doLoadProperty(Locale locale) throws HinemosWebException {
        // 中間変数を宣言
        Property propertyHistory = null;
        GetHistoryFilterPropertyBusiness business = new GetHistoryFilterPropertyBusiness();
        propertyHistory = business.getHistoryFilterProperty(locale);

        return propertyHistory;
    }

    /**
     * Convert data to JSON structure
     * 
     * @param propertyHistory
     *            : Property
     * @return TreeGridJson
     */
    private TreeGridJson doLoadDataJson(Property propertyHistory) {
        GetHistoryFilterPropertyBusiness business = new GetHistoryFilterPropertyBusiness();
        return business.doConvertToJson(propertyHistory);
    }
}