/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetJobTreeBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for get Job tree
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetJobTreeServlet extends CommonServlet {
    private static final long serialVersionUID = -4383433394811974899L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetJobTreeServlet.class);

    /**
     * Get Job tree
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        CommonJson result = null;

        try {
            // 中間変数を宣言
            NamingContext namingContext = doLoadNamingContext(request);

            // Load job tree
            JobTreeItem jobTreeItem = doLoadTreeItem(namingContext, request);

            // Create JSON
            result = doLoadDataJson(jobTreeItem, request);

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }

        return result;
    }

    /**
     * @param namingContext
     * @param request
     * @return
     * @throws HinemosWebException
     */
    private JobTreeItem doLoadTreeItem(NamingContext namingContext,
            HttpServletRequest request) throws HinemosWebException {
        GetJobTreeBusiness job = new GetJobTreeBusiness();
        JobTreeItem jobTreeItem = job.getJobTree(namingContext,
                request.getLocale());
        return jobTreeItem;
    }

    /**
     * Convert data to JSON structure
     * 
     * @param jobTreeItem
     *            : JobTreeItem
     * @return CommonJson
     */
    private CommonJson doLoadDataJson(JobTreeItem jobTreeItem,
            HttpServletRequest request) throws HinemosWebException {
        GetJobTreeBusiness business = new GetJobTreeBusiness();
        return business.doConvertToJson(jobTreeItem, getUserName(request));
    }
}
