/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidRequestParameterException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetRunScheduleDetailBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetRunScheduleDetailListBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.form.RunScheduleDetailForm;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.TwoGridDataJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class used for get Schedule Detail info
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetRunScheduleDetailDataServlet extends CommonServlet {
    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetRunScheduleDetailDataServlet.class);

    /**
     * Get Schedule Detail info
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException 
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException, HinemosWebAccessException {

        CommonJson result = new CommonJson();

        try {
            // NammingContextを取得する
            NamingContext namingContext = doLoadNamingContext(request);

            // Get data form
            RunScheduleDetailForm form = getDataForm(request);

            List<CommonTableTreeItem> leftData = null;
            List<CommonTableTreeItem> rightData = null;

            String scheduleId = form.getScheduleId();
            String jobunitId = form.getJobunitId();
            
            if ((scheduleId == null || scheduleId.equals("")) ||
                (jobunitId == null || jobunitId.equals(""))) {
                leftData = new ArrayList<CommonTableTreeItem>();
                rightData = new ArrayList<CommonTableTreeItem>();
            } else {
                // Map request data
                leftData = doLoadListInfoData(form, namingContext);
                rightData = doLoadInfosData(form, namingContext, request.getLocale());
            }

            // Get table tree
            result = doLoadDataJson(leftData, rightData, form,
                    request.getLocale());

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }
        return result;
    }

    /**
     * @param form
     * @param namingContext
     * @return
     * @throws HinemosWebException
     */
    private List<CommonTableTreeItem> doLoadListInfoData(
            RunScheduleDetailForm form, NamingContext namingContext)
            throws HinemosWebException {

        GetRunScheduleDetailListBusiness business = new GetRunScheduleDetailListBusiness();

        List<CommonTableTreeItem> listItem = business.getRunScheduleDetailList(
                form, namingContext);

        return listItem;
    }

    /**
     * Get Schedule Detail list
     * 
     * @param form
     *            : RunScheduleDetailForm
     * @param namingContext
     *            : NamingContext
     * @return HinemosWebException
     */
    private List<CommonTableTreeItem> doLoadInfosData(
            RunScheduleDetailForm form, NamingContext namingContext,
            Locale locale) throws HinemosWebException {

        GetRunScheduleDetailBusiness business = new GetRunScheduleDetailBusiness();
        List<CommonTableTreeItem> listItem = business.doLoadListInfoData(form,
                namingContext);

        return listItem;
    }

    /**
     * Check valid parameter
     * 
     * @param form
     *            : RunScheduleDetailForm
     * @return boolean
     */
    private boolean isValidRequestParam(RunScheduleDetailForm form) {
        boolean isValid = true;
        Long base = form.getBase();

        // Check request base (manager)
        // http リクエストからユーザID判定する
        if (base == null) {
            isValid = false;
            logUtils.error("base is null");
        } else if (base == 0L) {
            isValid = false;
            logUtils.error("base is invalid");
        }
        return isValid;
    }

    /**
     * @param request
     * @return
     * @throws HinemosWebException
     */
    private RunScheduleDetailForm getDataForm(HttpServletRequest request)
            throws HinemosWebException {
        RunScheduleDetailForm form = new RunScheduleDetailForm();
        PopulateBeanUtils.populateBean(form, request);

        // Check parameters of request
        if (!isValidRequestParam(form)) {
            throw new HinemosWebInvalidRequestParameterException();
        }

        return form;
    }

    /**
     * Convert data to JSON structure
     * 
     * @param form
     *            : RunScheduleForm
     * @param listInfoData
     *            : ArrayList<ArrayList<Object>>
     * @return GridDataJson
     * @throws HinemosWebInvalidNumberSizeDataException
     */
    private TwoGridDataJson doLoadDataJson(List<CommonTableTreeItem> leftData,
            List<CommonTableTreeItem> rightData, RunScheduleDetailForm form,
            Locale locale) throws HinemosWebException {
        TwoGridDataJson result = new TwoGridDataJson();

        GetRunScheduleDetailListBusiness leftBusiness = new GetRunScheduleDetailListBusiness();
        GetRunScheduleDetailBusiness rightBusiness = new GetRunScheduleDetailBusiness();

        result.setLeftData(leftBusiness.doConvertToJson(leftData, form));
        result.setRightData(rightBusiness.doConvertToJson(rightData, form,
                locale));

        List<String> colNames = rightBusiness.getColNames();
        if (colNames != null) {
            result.addUserdata(JsConstant.GRID_COL_NAMES, colNames);
        }
        return result;
    }
}