/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jnp.interfaces.NamingContext;

import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.form.GridForm;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetScheduleBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class used for get Schedule info
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetScheduleServlet extends CommonServlet {
    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetScheduleServlet.class);

    /**
     * Get Schedule info
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        CommonJson result = new CommonJson();

        try {
            // NammingContextを取得する
            NamingContext namingContext = doLoadNamingContext(request);

            List<List<Object>> list = doLoadListInfoData(request, namingContext);

            // Create JSON
            result = doLoadDataJson(list);

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }
        return result;
    }

    /**
     * Get Schedule info
     * 
     * @param request
     *            : HttpServletRequest
     * @param namingContext
     *            : NamingContext
     * @return ArrayList<JobSchedule>
     * @throws HinemosWebException
     */
    private List<List<Object>> doLoadListInfoData(HttpServletRequest request,
            NamingContext namingContext) throws HinemosWebException {
        // スコープ情報一覧データ(ScopeInfoData)を取得
        GridForm form = new GridForm();
        PopulateBeanUtils.populateBean(form, request);
        GetScheduleBusiness business = new GetScheduleBusiness();
        return business.getSchedule(form, namingContext);
    }

    /**
     * Convert data to JSON structure
     * 
     * @param listInfoData
     *            : ArrayList<JobSchedule>
     * @return GridDataJson
     */
    private GridDataJson doLoadDataJson(List<List<Object>> list) {
        GetScheduleBusiness business = new GetScheduleBusiness();
        return business.doConvertToJson(list);
    }
}