/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.listener;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;

import com.necsoft.hinemos.webclient.jobmanagement.servlet.GetJobTableDefineServlet;
import com.necsoft.hinemos.webclient.util.HinemosWebProperty;
import com.necsoft.hinemos.webclient.util.LogUtils;

public class ServletLifeContextListener implements ServletContextListener {
    private static LogUtils logUtils = LogUtils
    .getLogUtils(GetJobTableDefineServlet.class);
    /*
     * This method is invoked when the Web Application has been removed and is
     * no longer able to accept requests (non-Javadoc)
     * 
     * @see javax.servlet.ServletContextListener#contextDestroyed(javax.servlet.
     * ServletContextEvent)
     */
    public void contextDestroyed(ServletContextEvent event) {
        // HinemosWebLogging.removeFromRepository();
        logUtils.error("Hinemos Web App. Has Been Removed");        
    }

    /*
     * This method is invoked when the Web Application is ready to service
     * requests
     */
    public void contextInitialized(ServletContextEvent event) {
        String realRootPath = event.getServletContext().getRealPath("/");

        // Get configured properties
        try {
            HinemosWebProperty.init(realRootPath);
            logUtils.error(HinemosWebProperty.getConfig("Greeting"));
        } catch (ServletException e) {
            logUtils.error("CAN'T GET FILE CONFIGURED PROPERTIES");
        }
    }
}