/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.monitor.business;

import java.util.Locale;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidDataException;
import com.necsoft.hinemos.webclient.monitor.action.GetStatusFilterProperty;

public class GetStatusFilterPropertyBusiness {
    public Property getStatusFilterProperty(NamingContext namingContext,
            Locale locale) throws HinemosWebException {
        // 中間変数を宣言
        Property propertyStatus = null;
        // イベント情報一覧を取得
        GetStatusFilterProperty getStatusFilterProperty = new GetStatusFilterProperty();
        getStatusFilterProperty.setNamingContext(namingContext);

        propertyStatus = getStatusFilterProperty.getProperty(locale);

        if (propertyStatus == null) {
            throw new HinemosWebInvalidDataException(
                    "exception.monitor.status.filter.data");
        }
        return propertyStatus;
    }
}
