/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.action;

import java.util.Locale;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.repository.util.EjbConnectionManager;

/**
 * ファシリティ一覧を取得するクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetFacilityTree {

    // namingContextを定義
    private NamingContext m_namingContext = null;

    /**
     * namingContextを設定
     * 
     * @param namingContext
     * @return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_namingContext = namingContext;
    }

    /**
     * ファシリティ一覧を取得する
     * 
     * @param ロケール
     * @return　ファシリティ一覧
     * @throws HinemosWebException
     */
    public FacilityTreeItem getFacilityTree(Locale locale)
            throws HinemosWebException {
        FacilityTreeItem item = null;

        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        RepositoryController repository = ejbConnectionManager
                .getRepositoryController();

        if (repository == null) {
            return null;
        }

        try {
            item = repository.getFacilityTree(locale);
        } catch (Exception e) {
            throw new HinemosWebException(
                    "exception.repository.facilitytree.action");
        }

        return item;
    }
}
