/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.action;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.repository.bean.NodeScopeTabelDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * 割り当てスコープビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeScopeTableDefine {

    // ----- instance メソッド ----- //

    /**
     * 全てのノード一覧を取得します。<BR>
     * 
     * @return ノード一覧
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        /** 出力用変数 */
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();
        // Locale locale = Locale.getDefault();

        /** メイン処理 */
        tableDefine.add(NodeScopeTabelDefine.SCOPE, new TableColumnInfoJs(
                WebMessages.getString("scope", locale), TableColumnInfo.NONE,
                300, SWT.LEFT));

        return tableDefine;
    }
}