/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.repository.bean;

import java.io.Serializable;
import java.util.ArrayList;

import com.necsoft.hinemos.webclient.bean.TreeInfo;

/**
 * ファシリティ情報定義するクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class FacilityTreeBean extends TreeInfo implements Serializable {
    /**
	 * 
	 */
    private static final long serialVersionUID = 4112657628294404428L;

    private String facilityId;

    private String path;

    private boolean valid;
    
    private String key;

    private ArrayList<FacilityTreeBean> children;

    public FacilityTreeBean() {
        this.children = new ArrayList<FacilityTreeBean>();
        valid = true;
    }

    public boolean isValid() {
        return valid;
    }

    public void addChildren(FacilityTreeBean child) {
        this.children.add(child);
    }

    /**
     * @return the facilityId
     */
    public String getFacilityId() {
        return facilityId;
    }

    /**
     * @param facilityId the facilityId to set
     */
    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    /**
     * @return the path
     */
    public String getPath() {
        return path;
    }

    /**
     * @param path the path to set
     */
    public void setPath(String path) {
        this.path = path;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    /**
     * @return the children
     */
    public ArrayList<FacilityTreeBean> getChildren() {
        return children;
    }

    /**
     * @param children the children to set
     */
    public void setChildren(ArrayList<FacilityTreeBean> children) {
        this.children = children;
    }

    /**
     * @param valid the valid to set
     */
    public void setValid(boolean valid) {
        this.valid = valid;
    }
}
