/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.bean.NodeListTabelDefine;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.repository.RepositoryConstants;
import com.necsoft.hinemos.webclient.repository.action.GetNodeList;
import com.necsoft.hinemos.webclient.repository.form.NodeListForm;

/**
 * 登録ノードのリストを取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeListBusiness {

    public GridDataJson getNodeList(NodeListForm form, Property condition,
            NamingContext namingContext) throws HinemosWebException {

        GridDataJson result = null;
        ArrayList<ArrayList> listInfoData = null;
        if (condition == null) {
            listInfoData = getNodeList(namingContext);
        } else {
            listInfoData = getNodeList(condition, namingContext);
        }

        // Sort data
        DataProcess.sortData(form, listInfoData,
                NodeListTabelDefine.SORT_COLUMN_INDEX,
                NodeListTabelDefine.SORT_ORDER,
                RepositoryConstants.NODE_LIST_TABLE_HEADER_NUM);
        // Convert to json
        result = DataProcess.doConvertToJson(listInfoData);

        return result;
    }

    private ArrayList<ArrayList> getNodeList(NamingContext namingContext)
            throws HinemosWebException {
        ArrayList<ArrayList> listNodeData;
        // ステータス情報一覧データ(NodeInfoData)を取得
        GetNodeList nodeList = new GetNodeList();
        nodeList.setNamingContext(namingContext);
        listNodeData = nodeList.getAll();
        return listNodeData;
    }

    private ArrayList<ArrayList> getNodeList(Property condition,
            NamingContext namingContext) throws HinemosWebException {
        ArrayList<ArrayList> listNodeData;
        // ステータス情報一覧データ(NodeInfoData)を取得
        GetNodeList nodeList = new GetNodeList();
        nodeList.setNamingContext(namingContext);
        listNodeData = nodeList.get(condition);

        return listNodeData;
    }
}
