/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;
import java.util.Locale;

import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.CssClass;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebHeaderInvalidException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.GridHeaderJson;
import com.necsoft.hinemos.webclient.repository.RepositoryConstants;
import com.necsoft.hinemos.webclient.repository.action.GetScopeListTableDefine;

/**
 * This class used for get header of scope view
 * 
 * @version 1.0
 * @date 2011/12/14
 */
public class GetScopeListTableDefineBusiness {

    public CommonJson getScopeListTableDefine(Locale locale)
            throws HinemosWebHeaderInvalidException {
        // 中間変数を宣言
        ArrayList<TableColumnInfoJs> tblDefine = null;
        GridHeaderJson result = null;
        // イベントテーブルヘッダー定義データ(ScopeTableDefine)を取得
        tblDefine = GetScopeListTableDefine.get(locale);

        // イベントテーブルヘッダー定義データの項目数チェック
        if (tblDefine.size() != RepositoryConstants.SCOPE_LIST_TABLE_HEADER_NUM) {
            // 項目数が不足の場合
            throw new HinemosWebHeaderInvalidException(
                    "exception.repository.scope.number.header");
        }
        tblDefine.get(0).setClasses(CssClass.GRID_FIRST_COLUMN);
        result = DataProcess.doConvertToJson(tblDefine, true, locale);

        return result;
    }
}
