/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.CssClass;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebHeaderInvalidException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.business.GetNodeListTableDefineBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for display header of node view
 * 
 * @version 1.0
 * @date 2011/12/14
 */
public class GetNodeListTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -975394539239284271L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetNodeListTableDefineServlet.class);

    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();

        try {
            ArrayList<TableColumnInfoJs> tblDefine = doLoadTableDefine(request
                    .getLocale());

            setModelProperties(tblDefine);

            result = DataProcess.doConvertToJson(tblDefine, true,
                    request.getLocale());
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }
        return result;
    }

    /**
     * Get header list
     * 
     * @return ArrayList<TableColumnInfoJs>
     * @throws HinemosWebHeaderInvalidException
     * @throws IOException
     */
    private ArrayList<TableColumnInfoJs> doLoadTableDefine(Locale locale)
            throws HinemosWebException {
        GetNodeListTableDefineBusiness business = new GetNodeListTableDefineBusiness();
        return business.getNodeListTableDefine(locale);
    }

    /**
     * @param tblDefine
     */
    private void setModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        // Set priority class
        tblDefine.get(0).setClasses(CssClass.GRID_FIRST_COLUMN);
    }
}
