/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



package com.necsoft.hinemos.webclient.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import com.necsoft.hinemos.webclient.exception.HinemosWebDateTimeException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;

public class DateUtil {

    private static final String DEFAULT = "DEFAULT";

    private static final String ENGLISH = Locale.ENGLISH.getLanguage();

    private static final String DEFAULT_FORMAT = "yyyy/MM/dd HH:mm:ss";

    private static final String ENGLISH_FORMAT = "yyyy/MM/dd HH:mm:ss";

    private static Map<String, SimpleDateFormat> dateTimeFormatMap = null;

    private static SimpleDateFormat getSimpleDataFormat(String lang) {
        if (dateTimeFormatMap == null) {
            dateTimeFormatMap = new HashMap<String, SimpleDateFormat>();
            dateTimeFormatMap
                    .put(DEFAULT, new SimpleDateFormat(DEFAULT_FORMAT));
            dateTimeFormatMap
                    .put(ENGLISH, new SimpleDateFormat(ENGLISH_FORMAT));
        }

        if (dateTimeFormatMap.containsKey(lang)) {
            return dateTimeFormatMap.get(lang);
        } else {
            return dateTimeFormatMap.get(DEFAULT);
        }
    }

    /*
     * 日時を取得
     * 
     * @param Long
     * 
     * @return 日時の文字列
     */
    public static String getStringFromLongDate(Long longTime, String lang) {
        return getSimpleDataFormat(lang).format(longTime);
    }

    /*
     * 日時を取得
     * 
     * @param Date
     * 
     * @return 日時の文字列
     */
    public static String getStringFromDate(Date dateTime, String lang) {
        return getSimpleDataFormat(lang).format(dateTime);
    }

    /*
     * DateToString
     */
    public static Date getDateFromString(String stringTime, String lang)
            throws HinemosWebException {
        if ((stringTime == null) || stringTime.equals("")) {
            return null;
        }

        try {
            return getSimpleDataFormat(lang).parse(stringTime);
        } catch (ParseException e) {
            throw new HinemosWebDateTimeException(
                    "exception.common.datefromstringtime.parse");
        }
    }
}
