/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



package com.necsoft.hinemos.webclient.util;

import java.util.ArrayList;

import com.clustercontrol.bean.ConvertValueConstant;
import com.clustercontrol.bean.PingRunCountConstant;
import com.clustercontrol.bean.PingRunIntervalConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.necsoft.hinemos.webclient.bean.LabelValue;

/**
 * This class used for load Constant data
 * 
 * @version 1.0
 * @since 2011/12/14
 **/
public class LoadConstant {

    public static ArrayList<LabelValue> loadIntervals() {
        ArrayList<LabelValue> bean = new ArrayList<LabelValue>();
        LabelValue item;

        item = new LabelValue();
        item.setLabel(RunIntervalConstant.STRING_MIN_01);
        item.setValue(String.valueOf(RunIntervalConstant.TYPE_MIN_01));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(RunIntervalConstant.STRING_MIN_05);
        item.setValue(String.valueOf(RunIntervalConstant.TYPE_MIN_05));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(RunIntervalConstant.STRING_MIN_10);
        item.setValue(String.valueOf(RunIntervalConstant.TYPE_MIN_10));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(RunIntervalConstant.STRING_MIN_30);
        item.setValue(String.valueOf(RunIntervalConstant.TYPE_MIN_30));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(RunIntervalConstant.STRING_MIN_60);
        item.setValue(String.valueOf(RunIntervalConstant.TYPE_MIN_60));
        bean.add(item);

        return bean;
    }

    public static ArrayList<LabelValue> loadFailValues() {
        ArrayList<LabelValue> bean = new ArrayList<LabelValue>();
        LabelValue item;

        item = new LabelValue();
        item.setLabel(PriorityConstant.STRING_CRITICAL);
        item.setValue(String.valueOf(PriorityConstant.TYPE_CRITICAL));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(PriorityConstant.STRING_WARNING);
        item.setValue(String.valueOf(PriorityConstant.TYPE_WARNING));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(PriorityConstant.STRING_INFO);
        item.setValue(String.valueOf(PriorityConstant.TYPE_INFO));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(PriorityConstant.STRING_UNKNOWN);
        item.setValue(String.valueOf(PriorityConstant.TYPE_UNKNOWN));
        bean.add(item);

        return bean;
    }

    public static ArrayList<LabelValue> loadPingCounts() {
        ArrayList<LabelValue> bean = new ArrayList<LabelValue>();
        LabelValue item;

        item = new LabelValue();
        item.setLabel(PingRunCountConstant.STRING_COUNT_01);
        item.setValue(String.valueOf(PingRunCountConstant.TYPE_COUNT_01));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(PingRunCountConstant.STRING_COUNT_02);
        item.setValue(String.valueOf(PingRunCountConstant.TYPE_COUNT_02));
        bean.add(item);

        return bean;
    }

    public static ArrayList<LabelValue> loadPingIntervals() {
        ArrayList<LabelValue> bean = new ArrayList<LabelValue>();
        LabelValue item;

        item = new LabelValue();
        item.setLabel(PingRunIntervalConstant.STRING_SEC_01);
        item.setValue(String.valueOf(PingRunIntervalConstant.TYPE_SEC_01));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(PingRunIntervalConstant.STRING_SEC_02);
        item.setValue(String.valueOf(PingRunIntervalConstant.TYPE_SEC_02));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(PingRunIntervalConstant.STRING_SEC_05);
        item.setValue(String.valueOf(PingRunIntervalConstant.TYPE_SEC_05));
        bean.add(item);

        return bean;
    }

    public static ArrayList<LabelValue> loadSnmpVersions() {
        ArrayList<LabelValue> bean = new ArrayList<LabelValue>();
        LabelValue item;

        item = new LabelValue();
        item.setLabel(SnmpVersionConstant.STRING_V1);
        item.setValue(String.valueOf(SnmpVersionConstant.STRING_V1));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(SnmpVersionConstant.STRING_V2);
        item.setValue(String.valueOf(SnmpVersionConstant.STRING_V2));
        bean.add(item);

        return bean;
    }

    public static ArrayList<LabelValue> loadConvertValues() {
        ArrayList<LabelValue> bean = new ArrayList<LabelValue>();
        LabelValue item;

        item = new LabelValue();
        item.setLabel(ConvertValueConstant.STRING_NO);
        item.setValue(String.valueOf(ConvertValueConstant.TYPE_NO));
        bean.add(item);
        item = new LabelValue();
        item.setLabel(ConvertValueConstant.STRING_DELTA);
        item.setValue(String.valueOf(ConvertValueConstant.TYPE_DELTA));
        bean.add(item);

        return bean;
    }

}
