<?php
/**
 *	Xeblog/Base.php
 *
 *	@author		your name
 *	@package	Xanhte
 *	@version	$Id: skel.action.php,v 1.4 2005/01/04 12:53:26 fujimoto Exp $
 */


/**
 *	xeblogζ̥μ
 *
 *	@author		your name
 *	@access		public
 *	@package	Xanhte
 */
// Υ⥸塼Ǹ´˻Ȥ
class Xanhte_Action_Xeblog extends Ethna_ActionClass
{

	function authenticate()
	{
		global $xoopsModule, $xoopsModuleConfig  ;

		// gpermˤ븢³ǧ
		require_once 'XanhteLib/gperm_const.php';
		// $action $module_dir.'_'.$actionDatial ǥå
		$action = $this->_getLimitedAction();
		$priv = $this->gpermmanager->isPrivilege('xeblog_global', constant('GPERM_'.strtoupper($action)));
		// 󤴤
		if(!$priv){
			$redirect_url = sprintf('%s/modules/%s/index.php', XOOPS_URL , $xoopsModule->dirname()) ;
			if(preg_match('/^xeblog_post/', $action)){
				$redirect_msg = _BL_ANON_CANNOT_POST_SORRY ;
			}elseif(preg_match('/^xeblog_details/',$action)){
				$redirect_msg = _BL_CANNOT_READ_SORRY ;
			}elseif(preg_match('/^xeblog_imagemanager/',$action)){
				$redirect_url = sprintf('%s/modules/xanhte/util/window_close.html', XOOPS_URL) ;
				$redirect_msg = _BL_CANNOT_USE_IMAGEMANAGER_SORRY ;
			}else{
				$redirect_url = sprintf('%s/user.php', XOOPS_URL ) ;
				$redirect_msg = _BL_CANNOT_READ_SORRY ;
			}
			redirect_header($redirect_url, 5, $redirect_msg);
			exit;
		}
		
	  // categoryˤ븢³ǧ
		if($xoopsModuleConfig['category_permission']){
			$redirect_url = sprintf('%s/modules/%s/index.php', XOOPS_URL , $xoopsModule->dirname()) ;
			$redirect_msg = _BL_CANNOT_READ_SORRY ;
			// (Details)
			$blog_id = $this->af->get('blog_id');
			$filter = $this->xeblogE->getXeblogFilter($blog_id);
			$entry =& $this->xeblogE->getEntryObjectProp( null, $filter);
			if($blog_id && $this->_getLimitedAction() == 'xeblog_details'){
				if(empty($entry)){
					redirect_header($redirect_url, 5, $redirect_msg);
					exit;
				}
			  }
			if($this->_getLimitedAction()=='xeblog_post'){
				if(!$this->xeblogC->isPostableCategory($entry['cat_id'])){
					$redirect_msg = _BL_ANON_CANNOT_POST_SORRY ;
					redirect_header($redirect_url, 5, $redirect_msg);
					exit;
				}				
			}
			// cat_idȤ(Index)
			$cat_id = $this->af->get('cat_id');
			if($cat_id){
				if($this->_getLimitedAction()=='xeblog_index'){
					if(!$this->xeblogC->isReadableCategory($cat_id)){
						redirect_header($redirect_url, 5, $redirect_msg);
						exit;
					}
				}
			}
		}
		return null ;
	}

	

	 /**
	  * ƥץ졼ȤDB̾ȥեѥsetApp
	  * @access protected
	  * @return null
	  */
	function setTemplatePath($action){
		global $xoopsModule ;

		if(!preg_match('/^\w+$/', $action)){
			return null ;
		}
		// FILE
		$this->af->setApp('template_main_file', sprintf('%s/modules/%s/templates/%s_%s.html',
												   XOOPS_ROOT_PATH, $xoopsModule->dirname(), $xoopsModule->dirname(), strtolower($action))) ;
		// DB
		$this->af->setApp('template_main_db', sprintf('db:%s_%s.html', $xoopsModule->dirname(), strtolower($action)));
	}
	
	/***
	 * ¥åѤAction̾
	 * (GpermǻȤAction̾첽:action_post_doaction_postGpermǤaction_postȤư)
	 * @access private
	 * @return string
	 */
	function _getLimitedAction(){
		global $xoopsModule ;
		if(!is_object($xoopsModule)) return '' ;
		
		$action = $this->backend->ctl->getCurrentActionName();
		$action_array = explode('_', $action);
		for($i=0; $i<count($action_array); $i++){
			if($action_array[$i] == $xoopsModule->dirname() ){
				$limited_action = sprintf('%s_%s', $action_array[$i++], $action_array[$i]) ;
				return $limited_action ;
			}
		}
		
		return '' ;
	}
	

	
	/**
	 *	AjaxǻȤ褦XMLǤФ
	 *
	 *	@access	protected
	 *	@return	string	XML
	 */
	function _getXML4Ajax($data, $rootTag){
	
		$options = array(
			"mode" => "simplexml" ,
			"indent"    => "    ",
			"linebreak" => "\n",
			"typeHints" => false,
			"addDecl"   => true,
			"encoding"  => 'UTF-8',
			"rootName"  => "data",
			"defaultTagName" => "item",
			"attributesArray" => "_attributes",
			'cdata' => false,
			);		
		
		require_once 'XML/Serializer.php' ;
		$Serializer = &new XML_Serializer($options);
		$status = $Serializer->serialize(array($rootTag=>$data));
		if (PEAR::isError($status)){
			die($status->getMessage());
		}
		
		return $Serializer->getSerializedData();
		
	
	}	

}
?>
