<?php
// vim: foldmethod=marker
/**
 *	Ethna_DB_PEAR.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_DB_PEAR.php,v 1.2 2005/04/07 12:55:46 fujimoto Exp $
 */

// {{{ Ethna_DB_PEAR
/**
 *	Ethna_DB饹μ(PEAR)
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_DB_PEAR extends Ethna_DB
{
	/**#@+
	 *	@access	private
	 */

	/**	@var	object	DB				PEAR DB֥ */
	var $db;

	/**	@var	array	ȥ󥶥å */
	var	$transaction = array();


	/**	@var	object	Ethna_Logger	֥ */
	var $logger;

	/**	@var	object	Ethna_AppSQL	SQL֥ */
	var $sql;

	/**	@var	string	DB(mysql, pgsql...) */
	var $type;

	/**	@var	string	DSN */
	var $dsn;

	/**	@var	bool	³³ե饰 */
	var $persistent;

	/**#@-*/


	// {{{ Ethna_DB饹μ
	/**
	 *	Ethna_DB_PEAR饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Controller	&$controller	ȥ饪֥
	 *	@param	string	$dsn								DSN
	 *	@param	bool	$persistent							³³
	 */
	function Ethna_DB_PEAR(&$controller, $dsn, $persistent)
	{
		$this->dsn = $dsn;
		$this->persistent = $persistent;
		$this->db = null;
		$this->logger =& $controller->getLogger();
		$this->sql =& $controller->getSQL();

		$dsninfo = DB::parseDSN($dsn);
		$this->type = $dsninfo['phptype'];
	}

	/**
	 *	DB³
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function connect()
	{
		$this->db =& DB::connect($this->dsn, $this->persistent);
		if (DB::isError($this->db)) {
			$error = Ethna::raiseError('DB³顼: %s', E_DB_CONNECT, $this->db->getUserInfo());
			$error->addUserInfo($this->db);
			$this->db = null;
			return $error;
		}

		return 0;
	}

	/**
	 *	DB³Ǥ
	 *
	 *	@access	public
	 */
	function disconnect()
	{
		if (is_null($this->db)) {
			return;
		}
		$this->db->disconnect();
	}

	/**
	 *	DB³֤֤
	 *
	 *	@access	public
	 *	@return	bool	true: false:顼
	 */
	function isValid()
	{
		if (is_null($this->db)) {
			return false;
		} else {
			return true;
		}
	}

	/**
	 *	DBȥ󥶥򳫻Ϥ
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function begin()
	{
		if (count($this->transaction) > 0) {
			$this->transaction[] = true;
			return 0;
		}

		$r = $this->query('BEGIN;');
		if (Ethna::isError($r)) {
			return $r;
		}
		$this->transaction[] = true;

		return 0;
	}

	/**
	 *	DBȥ󥶥Ǥ
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function rollback()
	{
		if (count($this->transaction) == 0) {
			return 0;
		}

		// Хåϥå˴ؤ餺ȥ󥶥򥯥ꥢ
		$r = $this->query('ROLLBACK;');
		if (Ethna::isError($r)) {
			return $r;
		}
		$this->transaction = array();

		return 0;
	}

	/**
	 *	DBȥ󥶥λ
	 *
	 *	@access	public
	 *	@return	mixed	0:ｪλ Ethna_Error:顼
	 */
	function commit()
	{
		if (count($this->transaction) == 0) {
			return 0;
		} else if (count($this->transaction) > 1) {
			array_pop($this->transaction);
			return 0;
		}

		$r = $this->query('COMMIT;');
		if (Ethna::isError($r)) {
			return $r;
		}
		array_pop($this->transaction);

		return 0;
	}
	// }}}

	// {{{ Ethna_AppObjectϢȤΤμ
	/**
	 *	DBפ֤
	 *
	 *	@access	public
	 *	@return	string	DB
	 */
	function getType()
	{
		return $this->type;
	}

	/**
	 *	ȯԤ
	 *
	 *	@access	public
	 *	@param	string	$query	SQLʸ
	 *	@return	mixed	DB_Result:̥֥ Ethna_Error:顼
	 */
	function &query($query)
	{
		return $this->_query($query);
	}

	/**
	 *	ľINSERTˤID
	 *
	 *	³DBmysqlʤmysql_insert_id()֤ͤ
	 *
	 *	@access	public
	 *	@return	mixed	int:ľINSERTˤ줿ID null:̤ݡ
	 */
	function getInsertId()
	{
		if ($this->isValid() == false) {
			return null;
		} else if ($this->type == 'mysql') {
			return mysql_insert_id($this->db->connection);
		}

		return null;
	}

	/**
	 *	ľΥˤ빹Կ
	 *
	 *	@access	public
	 *	@return	int		Կ
	 */
	function affectedRows()
	{
		return $this->db->affectedRows();
	}
	// }}}

	// {{{ Ethna_DB_PEARȼμ
	/**
	 *	SQLʸꥯȯԤ
	 *
	 *	@access	public
	 *	@param	string	$sqlid		SQL-ID(+)
	 *	@return	mixed	DB_Result:̥֥ Ethna_Error:顼
	 */
	function &sqlquery($sqlid)
	{
		$args = func_get_args();
		array_shift($args);
		$query = $this->sql->get($sqlid, $args);

		return $this->_query($query);
	}

	/**
	 *	SQLʸ
	 *	
	 *	@access	public
	 *	@param	string	$sqlid		SQL-ID
	 *	@return	string	SQLʸ
	 */
	function sql($sqlid)
	{
		$args = func_get_args();
		array_shift($args);
		$query = $this->sql->get($sqlid, $args);

		return $query;
	}

	/**
	 *	ơ֥å
	 *
	 *	@access	public
	 *	@param	mixed	åоݥơ֥̾
	 *	@return	mixed	DB_Result:̥֥ Ethna_Error:顼
	 */
	function lock($tables)
	{
		$this->message = null;

		$sql = "";
		foreach (to_array($tables) as $table) {
			if ($sql != "") {
				$sql .= ", ";
			}
			$sql .= "$table WRITE";
		}

		return $this->query("LOCK TABLES $sql");
	}

	/**
	 *	ơ֥Υå
	 *
	 *	@access	public
	 *	@return	mixed	DB_Result:̥֥ Ethna_Error:顼
	 */
	function unlock()
	{
		$this->message = null;
		return $this->query("UNLOCK TABLES");
	}

	/**
	 *	ȯԤ
	 *
	 *	@access	private
	 *	@param	string	$query	SQLʸ
	 *	@return	mixed	DB_Result:̥֥ Ethna_Error:顼
	 */
	function &_query($query)
	{
		$this->logger->log(LOG_DEBUG, "$query");
		$r =& $this->db->query($query);
		if (DB::isError($r)) {
			if ($r->getCode() == DB_ERROR_ALREADY_EXISTS) {
				$error = Ethna::raiseNotice('ˡ󥨥顼 SQL[%s]', E_DB_DUPENT, $query, $this->db->errorNative(), $r->getUserInfo());
			} else {
				$error = Ethna::raiseError('ꥨ顼 SQL[%s] CODE[%d] MESSAGE[%s]', E_DB_QUERY, $query, $this->db->errorNative(), $r->getUserInfo());
			}
			return $error;
		}
		return $r;
	}
	// }}}
}
// }}}
?>
