<?php
// vim: foldmethod=marker
/**
 *	Xanhte_CommentXoops.php
 *
 *	@author		ITOH Takashi 
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_RssManager
/**
 *	XOOPSΥORM
 *
 *	@author		ITOH Takashi <itoh@itt-web.net>
 *	@access		public
 *	@package	Sample
 */

class Xanhte_CommentXoopsManager extends Xanhte_AppManager
{

	/**
	 * Ȥޤ(ʣ)
	 * @access public
	 * @param int com_modid 
	 * @param int com_itemid
	 * @param int com_pid
	 * @param int com_rootid
	 * @param int com_uid
	 * @param int limit
	 * @param int start
	 * @return array
	 **/
	function getCommentProp($com_modid=false, $com_itemid=false, $com_pid=false, $com_rootid=false, $com_uid=false, $start=null, $limit=null ){
		global $xoopsUser ;
		
		$filter_def = array('com_modid', 'com_itemid', 'com_pid', 'com_rootid', 'com_uid');
		$filter = array();
		foreach($filter_def as $filter_ele){
			${$filter_ele}!==false and $filter[$filter_ele] =& new Ethna_AppSearchObject(${$filter_ele}, OBJECT_CONDITION_EQ);
		}
		!(is_object($xoopsUser) && $xoopsUser->isAdmin()) and $filter['com_status'] =& new Ethna_AppSearchObject(2, OBJECT_CONDITION_EQ );
		
		$comments = $this->getObjectPropList('CommentXoops', null, $filter, array('com_created'=>OBJECT_SORT_DESC), $start, $limit);
		return $comments ;
	}

	/**
	 * Ȥޤ(ñ)
	 * @access public
	 * @return object
	 **/
	function getComment($com_id=0){
		global $xoopsUser ;

		if(is_object($xoopsUser) && $xoopsUser->isAdmin()){
			$prop_def = array('com_id');
			$prop = array($com_id);
		}else{
			$prop_def = array('com_id', 'com_status');
			$prop = array($com_id, 2); // 2ϥƥ֤
		}
		$comment =& new Xanhte_CommentXoops(&$this->backend, $prop_def, $prop);
		return $comment ;
	}
	

	
	/**
	 * mapkeyˤꥳȤޤ
	 * @access public
	 * @param string mapkey
	 * @param int start
	 * @return array
	 **/
	function getCommentPropByMapkey($mapkey, $limit=1000, $start=0){
		global $xoopsUser ;
		
		$filter = array(
			'mapkey' =>  new Ethna_AppSearchObject($mapkey, OBJECT_CONDITION_EQ),
		);
		!(is_object($xoopsUser) && $xoopsUser->isAdmin()) and $filter['com_status'] =& new Ethna_AppSearchObject(2, OBJECT_CONDITION_EQ );
		
		$comments = $this->getObjectPropList('CommentXoops', null, $filter, array('com_created'=>OBJECT_SORT_DESC), $start, $limit);
		return $comments ;
	}



	
	/**
	 * ɽ֤뤿Υޥåԥ󥰤Ԥ
	 * ȤäƤ⡢ScriptPathGETñʤ
	 * @access public
	 * @return string
	 **/
	function getCommentMap(){
		$mapkey = $this->_getCommentMap();
		return $mapkey ;
	}
	
	
	
	/**
	 * ɽ֤뤿Υޥåԥ󥰤Ԥ
	 * -- 
	 * @access private
	 * @return string
	 **/
	function _getCommentMap(){
		
		$get = array();
		$fullURL = sprintf('http://%s%s', $_SERVER['SERVER_NAME'], $_SERVER['SCRIPT_NAME'] ) ;
		$modulePath = preg_replace("{XOOPS_URL}", '', $fullURL) ;
		$modulePath = preg_replace('|/index\.php$|', '', $modulePath) ;
		$var_gets = explode('&', $_SERVER['QUERY_STRING']);
		foreach($var_gets as $var_get){
			if(strpos($var_get, '=')!==false){
				list($key, $value) = explode('=',$var_get);
				if(!empty($value)){
					$get[$key] = $value ;
				}
			}
		}
		ksort($get);
		$ret = md5(serialize($get));
		return $ret ;
	}
}
// }}}

// {{{ Xanhte_Rss
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		ITOH Takashi
 *	@access		public
 *	@package	Sample
 */
class Xanhte_CommentXoops extends Xanhte_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
        var $table_def = array(
			'xoopscomments' => array(
				'primary' => true 
				)
	    );
	    
        var $prop_def = array(
			'com_id'=> array(
				'primary' => true,
				'key' => true,
				'seq' => true,
				'type' => VAR_TYPE_INT,
				'form_name' => 'com_id',
				'prop_name' => 'ID' ,
				),
			'com_pid'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'com_pid',
				'prop_name' => 'ID' ,
				),
			'com_rootid'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'gperm_itemid',
				'prop_name' => 'ROOTID' ,
				),
			'com_modid'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'gperm_modid',
				'prop_name' => '⥸塼ID' ,
				),
			'com_itemid'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'gperm_modid',
				'prop_name' => 'ƥID' ,
				),
			'com_icon'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'com_icon',
				'prop_name' => '̾' ,
				'regexp' => '/^[\w\.]{25}$/' ,
				),
			'com_created'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'com_created',
				'prop_name' => 'Ⱥ' ,
				),
			'com_modified'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'com_modified',
				'prop_name' => 'ѹ' ,
				),
			'com_uid'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'com_uid',
				'prop_name' => '桼ID' ,
				),
			'com_ip'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'com_ip',
				'prop_name' => 'IPɥ쥹' ,
				'regexp' => '/^[\d\.]{7,15}$/',
				),
			'com_title'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'com_title',
				'prop_name' => 'ȥ' ,
				),
			'com_text'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'com_text',
				'prop_name' => '' ,
				),
			'com_sig'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_BOOLEAN,
				'form_name' => 'com_sig',
				'prop_name' => 'ͥղ' ,
				),
			'com_status'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_BOOLEAN,
				'form_name' => 'com_status',
				'prop_name' => 'status' , // 1=> ǧԤ 2=>ƥ 3=>ɽ
				),
			'com_exparams'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'com_exparams',
				'prop_name' => '¾ѥ᡼' ,
				),
			'dohtml'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_BOOLEAN,
				'form_name' => 'dohtml',
				'prop_name' => 'htmlѴ' ,
				),
			'dosmiley'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_BOOLEAN,
				'form_name' => 'dosmiley',
				'prop_name' => 'ޥ꡼Ѵ' ,
				),
			'doxcode'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_BOOLEAN,
				'form_name' => 'doxcode',
				'prop_name' => 'XOOPS BBѴ' ,
				),
			'doimage'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_BOOLEAN,
				'form_name' => 'doimage',
				'prop_name' => 'ղ' ,
				),
			'dobr'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_BOOLEAN,
				'form_name' => 'dobr',
				'prop_name' => 'ư' ,
				),
	    // ʲjoin¦prop
			'guestname'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => '',
				'prop_name' => '' ,
				'table' => 'xoopscomments_extra',
				),
	        'mapkey'=> array(
				'primary' => false,
				'key' => true,
				'type' => VAR_TYPE_STRING,
				'form_name' => '',
				'prop_name' => '' ,
				'table' => 'xoopscomments_extra',
				),
			);
			
	/**
	 *	@var	array	JOINơ֥
	 *      'mainjointable' => array(
	 *           'JOIN'=> 'JOIN'
	 *       )
	 */

        var $table_join = array(
			'xoopscomments_extra' => array(
				'xoopscomments_extra.com_id' => 'xoopscomments.com_id',
				),
			);

	
	/**#@-*/	    
	
	/**#@-*/
	
	/**
	 *	ȥ饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_CommentXoops(&$backend, $key_type = null, $key = null, $prop = null)
	{
		$this->Xanhte_AppObject(&$backend, $key_type, $key, $prop);
	    // ֥ȼԤϤ˵Ҥޤ
	}
	
	/**
	 *	֥ȸSQLץ饰(ɲåơ֥)
	 *
	 *	sample:
	 *	<code>
	 *	return " LEFT JOIN bar_tbl ON foo_tbl.user_id=bar_tbl.user_id";
	 *	</code>
	 *
	 *	@access	protected
	 *	@return	string	ơ֥JOINSQLʸ
	 */
	function _SQLPlugin_SearchTable()
	{
		return parent::_SQLPlugin_SearchTable();
	}

	/**
	 *	֥ȸSQLץ饰(ɲþ)
	 *
	 *	sample:
	 *	<code>
	 *	$search_prop_def = array(
	 *	  'group_id' => array(
	 *	    'primary' => true, 'key' => true, 'type' => VAR_TYPE_INT,
	 *	    'form_name' => 'group_id', 'table' => 'group_user_tbl',
	 *	  ),
	 *	);
	 *	return $search_prop_def;
	 *	</code>
	 *
	 *	@access	protected
	 *	@return	array	ɲþ
	 */
	function _SQLPlugin_SearchPropDef()
	{
		return parent::_SQLPlugin_SearchPropDef();
	}
	
	
	/**
	 *	ȥեफε۽Ф
	 *
	 *	@access	public
	 *	@param	int		$option		OPJECT_IMPORT_IGNORE_NULL....
	 *	@param	array	$block_options						֥åץ
	 *	                $block_options[0] : Ȥξǧɬפɤ
	 *                  0:Ȥ˾ǧɬפʤ
	 *                  1:Ͽ桼Ͼǧ
	 *                  2:ƾǧɬ
	 *  1:ǧԤ 2:active 3:ɽ
	 */
	function importForm($option, $block_options){
		global $xoopsUser, $module_handler ;
	
		// եǤͿʤץѥƥͤinsert
		// com_modified / com_created
		$now = time();
		$this->set('com_modified', $now);
		if(!$this->get('com_id')){
			$this->set('com_created', $now);
		}
		$this->set('com_ip', $_SERVER['REMOTE_ADDR']) ; // com_ip
		switch(intval($block_options[0])){
		  case 0 :
			$status = 2 ;
			break ;
		  case 1 :
			$status = is_object($xoopsUser) ? 2 : 1 ;
			break ;
		  default :
		  case 2 :
			$status = 1 ;
			break ;
		}
		$this->set('com_status', $status); // com_status
		$uid = is_object($xoopsUser) ? $xoopsUser->uid() : 0 ;		
		$this->set('com_uid', $uid); // com_uid
		// mid
		!is_object($module_handler) and $module_handler = xoops_gethandler('module');
		$xanhte_module =& $module_handler->getByDirname('xanhte') ;
		$this->set('com_modid', $xanhte_module->mid()) ;
		
		parent::importForm($option);
		
	}
	
}
// }}}

?>