<?php
// vim: foldmethod=marker
/**
 *	Xanhte_SmartyPlugin.php
 */

// {{{ smarty_function_form_name
/**
 *	smarty function:եɽ̾
 *
 *	@param	string	$name	ե̾
 */

// XOOPS/smarty/plugins/function.form_inputʤɤϿƤؿ˴
unregister_tick_function('smarty_function_form_dhtml');


function smarty_function_form_name($params, &$smarty)
{
	extract($params);	// $name = form_input_name 

	$ctl =& Kcaffiliate_Controller::getInstance();
	$ae =& $ctl->getActionError();

	// ߥƥ֤ʥեʳΥե
	// ѤˤSmartyѿ𤵤(ޤ)
	$app = $smarty->get_template_vars('app');
	if (isset($app['__def__']) && $app['__def__'] != null) {
		if (isset($app['__def__'][$name])) {
			$def = $app['__def__'][$name];
		}
	} else {
		$af =& $ctl->getActionForm();
		$def = $af->getDef($name);
	}

	if (is_null($def) || isset($def['name']) == false) {
		$form_name = $name;
	} else {
		$form_name = $def['name'];
	}

	if ($ae->isError($name)) {
		// ϥ顼ξɽ
		print '<span class="error">' . $form_name . '</span>';
	} else {
		// ̾ɽ
		print '<span class="">' . $form_name . '</span>';
	}
	if (isset($def['required']) && $def['required'] == true) {
		// ɬܻɽ
		print '(*)';
	}
}



// {{{ smarty_function_form_input
/**
 *	smarty function:եॿ
 *
 *	빽ŬǤ(
 *
 *	sample:
 *	<code>
 *	{form_input name="mailaddress" attr="..."}
 *	</code>
 *
 *	@param	string	$name	ե̾
 */
function smarty_function_form_input($params, &$smarty)
{
	$c =& Ethna_Controller::getInstance();

	extract($params);	// $name = input_name , $attr = input_attributes

	$app = $smarty->get_template_vars('app');
	if (isset($app['__def__']) && $app['__def__'] != null) {
		if (isset($app['__def__'][$name])) {
			$def = $app['__def__'][$name];
		}
		$af =& $c->getActionForm();
	} else {
		$af =& $c->getActionForm();
		$def = $af->getDef($name);
	}

	if (isset($def['form_type']) == false) {
		$def['form_type'] = FORM_TYPE_TEXT;
	}
	
	!isset($attr) and $attr = '';

	if(is_array($def['form_type'])){
	$input = '' ;
	switch($def['form_type'][0]){
	  case FORM_TYPE_CHECKBOX :
		
		if(isset($def['values']) && is_array($def['values'])){
			$form_value = $af->get($name);
			foreach($def['values'] as $array_value=>$array_label){
				$label = substr(md5($array_value.rand()), 5,10) ;
				!isset($delimiter) and $delimiter = '&nbsp;';
				!isset($postfix) and $postfix = "<br/>\n";
				$checked = isset($form_value[$array_value]) ? 'checked="checked"' : '' ;
				$input .= sprintf('<input type="checkbox" name="%s[%s]" value="1" id="%s" %s>', $name, $array_value, $label, $checked) ;
				$input .= sprintf('%s<label for="%s">%s</label>%s', $delimiter, $label, $array_label, $postfix);
			}
		}
		break;
	}
	
	}else{

	switch ($def['form_type']) {
	case FORM_TYPE_FILE:
		$input = sprintf('<input type="file" name="%s"', $name);
		if ($attr) {
			$input .= " $attr";
		}
		$input .= ">";
		break;
	case FORM_TYPE_TEXTAREA:
		$input = sprintf('<textarea name="%s"', $name);
		if ($attr) {
			$input .= " $attr";
		}
		$input .= sprintf('>%s</textarea>', htmlspecialchars($af->get($name)));
		break;
	case FORM_TYPE_PASSWORD:
		$input = sprintf('<input type="password" name="%s" value="%s"', $name, htmlspecialchars($af->get($name)));
		if ($attr) {
			$input .= " $attr";
		}
		if (isset($def['max']) && $def['max']) {
			$input .= sprintf(' maxlength="%d"', $def['max']);
		}
		$input .= ">";
		break;
	case FORM_TYPE_CHECKBOX:
	case FORM_TYPE_RADIO:
		$value = isset($value) ? $value : 1 ;
		$id = isset($id) ? $id : '' ;
		$attr = isset($attr) ? $attr : '' ;
		if($def['form_type']==FORM_TYPE_RADIO){
			$type = 'radio';
			$checked = ($value==$af->get($name)) ? 'checked' : '' ;		
		}elseif($def['form_type']==FORM_TYPE_CHECKBOX){
			$type = 'checkbox' ;
			$checked = (!is_array($def['type']) && $af->get($name) ) ? 'checked' : '' ;
		}
		is_array($def['type']) and $name = $name.'[]';
		$input = sprintf('<input type="%s" name="%s" value="%s" id="%s" %s %s>', $type, $name, $value, $id, $attr ,$checked) ;
		break ;
	case FORM_TYPE_SELECT:
		!isset($size) and $size=1 ;
		$multiple = (isset($size) && $size>1) ? 'multiple="multiple"' : '' ;
		$name_ = !empty($multiple) ? $name.'[]' : $name ;
		$input = sprintf('<select name="%s" size="%d" %s %s>', $name_, $size, $attr, $multiple) . "\n" ;
		if(isset($def['options'])){
			foreach($def['options'] as $op_value=>$op_label){
				if(is_array($af->get($name))){
					$selected = in_array($op_value, $af->get($name)) ;
				}else{
					$selected = ($op_value==$af->get($name));
				}
				$input .= sprintf('<option value="%s" %s>%s</option>', $op_value, $selected ? 'selected="selected"' : "" ,$op_label) ;
			}
		}
		$input .= "</select>\n";
		break;
    case FORM_TYPE_TEXT:
		// fall thru
	default:
		$input = sprintf('<input type="text" name="%s" value="%s"', $name, htmlspecialchars($af->get($name)));
		if ($attr) {
			$input .= " $attr";
		}
		if (isset($def['max']) && $def['max']) {
			$input .= sprintf(' maxlength="%d"', $def['max']);
		}
		$input .= ">";
		break;
	}
	}
	print $input;
}
// }}}

// {{{ smarty_function_form_dhtml
/**
 *	smarty function:XOOPSե
 *
 *
 *	sample:
 *	<code>
 *	{radio name="yesno" list="$app.radio_list" value="$form.yesno"}
 *	</code>
 *
 *	@param	string	$name	ե̾
 *	@param	string	$value	ե
 *	@param	string	$caption ץ
 *	@param	string	$rows   
 *	@param	string	$cols   
 *	@param	string	$attr	class/idʤɤ°
 */
function smarty_function_form_dhtml($params, &$smarty)
{
	$c =& Ethna_Controller::getInstance();
	$af =& $c->getActionForm();
	
	extract($params);	// $name = input_name , $attr = input_attributes

	if(!class_exists('XoopsFormDhtmlTextArea')){
		if(!class_exists('XoopsFormTextArea')){
			if(!class_exists('XoopsFormElement')){
				require_once XOOPS_ROOT_PATH.'/class/xoopsform/formelement.php';
			}
			require_once XOOPS_ROOT_PATH.'/class/xoopsform/formtextarea.php';
		}
		require_once XOOPS_ROOT_PATH.'/class/xoopsform/formdhtmltextarea.php';
	}

	$r = '' ;
	!isset($caption) and $caption = '';
	!isset($rows) and $rows = 5;
	!isset($cols) and $cols = 50;
	!isset($hiddentext) and $hiddentext = 'xoopsHiddenText'.strval(rand(1,10000)) ;
	$dhtml =& new XoopsFormDhtmlTextArea($caption, $name, htmlspecialchars($af->get($name)), $rows, $cols, $hiddentext);
	$r = $dhtml->render();
	print $r ;
}
// }}}

// {{{ smarty_function_form_phpbb
/**
 *	smarty function:XOOPSե(phpbbǻȤƤΤܿ)
 *
 *
 *	sample:
 *	<code>
 *	{radio name="yesno" list="$app.radio_list" value="$form.yesno"}
 *	</code>
 *
 *	@param	string	$name	ե̾
 *	@param	string	$value	ե
 *	@param	string	$caption ץ
 *	@param	string	$rows   
 *	@param	string	$cols   
 *	@param	string	$attr	class/idʤɤ°
 */
function smarty_function_form_phpbb($params, &$smarty)
{
	$c =& Ethna_Controller::getInstance();
	$af =& $c->getActionForm();
	
	extract($params);	// $name = input_name , $attr = input_attributes

	if(!class_exists('XoopsFormPhpBBTextArea')){
		if(!class_exists('XoopsFormTextArea')){
			if(!class_exists('XoopsFormElement')){
				require_once XOOPS_ROOT_PATH.'/class/xoopsform/formelement.php';
			}
			require_once XOOPS_ROOT_PATH.'/class/xoopsform/formtextarea.php';
		}
		require_once XANHTE_ROOT_PATH.'/lib/XanhteLib/xoops/formphpbbtextarea.php';
	}

	$r = '' ;
	!isset($caption) and $caption = '';
	!isset($rows) and $rows = 5;
	!isset($cols) and $cols = 50;
	!isset($hiddentext) and $hiddentext = 'xoopsHiddenText'.strval(rand(1,10000)) ;

	$dhtml =& new XoopsFormPhpBBTextArea($caption, $name, htmlspecialchars($af->get($name)), $rows, $cols, $hiddentext);
	$r = $dhtml->render();
	print $r ;
}
// }}}


// {{{ smarty_function_form_xdate
/**
 *	smarty function:XOOPSdateե
 *
 *
 *	sample:
 *	<code>
 *	{radio name="yesno" list="$app.radio_list" value="$form.yesno"}
 *	</code>
 *
 *	@param	string	$name	ե̾
 *	@param	string	$value	ե
 *	@param	string	$caption ץ
 *	@param	string	$rows   
 *	@param	string	$cols   
 *	@param	string	$attr	class/idʤɤ°
 */
function smarty_function_form_xdate($params, &$smarty)
{
	$c =& Ethna_Controller::getInstance();
	$af =& $c->getActionForm();

	extract($params);	// $name = input_name , $attr = input_attributes

	if(!class_exists('XoopsFormElement')){
		require_once XOOPS_ROOT_PATH.'/class/xoopsform/formelement.php';
	}
	if(!class_exists('XoopsFormText')){
		require_once XOOPS_ROOT_PATH.'/class/xoopsform/formtext.php';
	}
	if(!class_exists('XoopsFormSelect')){
		require_once XOOPS_ROOT_PATH.'/class/xoopsform/formselect.php';
	}
	if(!class_exists('XoopsFormElementTray')){
		require_once XOOPS_ROOT_PATH.'/class/xoopsform/formelementtray.php';
	}
	require_once 'XanhteLib/xoops/myformdatetime.php';

	$r = '' ;
	!isset($caption) and $caption = '';
	!isset($y_width) and $y_width = 15;
	//
	$date_name = $name . '_date'; 
	$time_name = $name . '_time'; 
	list($y, $m, $d) = sscanf($af->get($date_name), '%d-%d-%d');
	$value = mktime(0, 0, 0, $m, $d, $y) + $af->get($time_name);
	$xdate =& new myXoopsFormDateTime($caption, $name, $y_width, $value) ;
	
	$r = $xdate->render();

	print $r ;
}
// }}}



/**
 *	smarty modifier:password_shadow()
 *
 *	ѥɤʤ󤫤*****Ѵ
 *
 *	sample:
 *	<code>
 *	{"12345"|password_shadow}
 *	</code>
 *	<code>
 *	12,345
 *	</code>
 *
 *	@param	string	$string	եޥåоʸ
 *	@return	string	եޥåȺѤʸ
 */
function smarty_modifier_password_shadow($string)
{
	if ($string === "" || $string == null) {
		return "";
	}
	return str_repeat('*', strlen($string));
}


?>
