/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatmount_main.c
 * @brief %jp{FAT{[ }EgR}h}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "hosaplfw.h"
#include "fatmount.h"
#include "driver/volume/fat/fatvol.h"



/* FAT{[ }EgR}h */
int FatMount_Main(int argc, char *argv[])
{
	HANDLE	hVolume;
	char	*pszMountName = NULL;
	char	*pszDevName   = NULL;
	int		iUnmount = 0;
	int		i;
		
	/* IvV */
	for ( i = 1; i < argc; i++ )
	{
		if ( argv[i][0] == '-' )
		{
			if ( argv[i][1] == 'u' && argv[i][2] == '\0' )
			{
				iUnmount = 1;
			}
		}
		else
		{
			if ( pszMountName == NULL )
			{
				pszMountName = argv[i];
			}
			else if ( pszDevName == NULL )
			{
				pszDevName = argv[i];
			}
		}
	}
	
	/* VXe[hڍs */
	if ( Process_EnterSystemMode() != PROCESS_ERR_OK )
	{
		return 1;	/* VXe */
	}
	
	if ( !iUnmount )	/* FAT{[}Eg */
	{
		/* p[^`FbN */
		if ( pszMountName == NULL || pszDevName == NULL )
		{
			Process_LeaveSystemMode();
			return 1;
		}
		
		/* FAT{[ */
		hVolume = FatVol_Create(pszDevName);
		if ( hVolume == HANDLE_NULL )
		{
			StdIo_PrintFormat("device open error\n");
			Process_LeaveSystemMode();
			return 1;
		}
		
		/* VXeɓo^ */
		File_AddVolume(pszMountName, hVolume);		
	}
	else	/* FAT{[A}Eg */
	{
		if ( pszMountName == NULL )
		{
			Process_LeaveSystemMode();
			return 1;
		}
		
		/* foCX𓾂 */
		hVolume = File_GetVolume(pszMountName);
		if ( hVolume ==  HANDLE_NULL )
		{
			Process_LeaveSystemMode();
			return 1;
		}
		
		/* Vbg_E */
		if ( Volume_Shutdown(hVolume) != FILE_ERR_OK )
		{
			StdIo_PrintFormat("shutdown failed\n");
			Process_LeaveSystemMode();
			return 1;
		}
		
		/* VXeO */
		File_RemoveVolume(pszMountName);
		
		/* {[폜 */
		FatVol_Delete(hVolume);
	}
	
	/* VXe[h𔲂 */
	Process_LeaveSystemMode();
	
	return 0;
}


/* end of file */
