/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  filecat_main.c
 * @brief %jp{t@CR}h}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */

#include <stdlib.h>
#include <string.h>
#include "hosaplfw.h"
#include "filecat.h"


#define FILECAT_BUFSIZE	4096


/* t@CR}h */
int FileCat_Main(int argc, char *argv[])
{
	HANDLE		hFile;
	int			i;
	FILE_SIZE	Size;
	void		*pBuf;

	/* obt@m */
	pBuf = Memory_Alloc(FILECAT_BUFSIZE);
	if ( pBuf == NULL )
	{
		return 1;
	}
	
	/*  */
	for ( i = 1; i < argc; i++ )
	{
		/* Open */
		if ( (hFile = File_Open(argv[i], FILE_OPEN_READ | FILE_OPEN_EXIST)) == HANDLE_NULL )
		{
			continue;
		}
		
		/* ǂݏo */
		while ( (Size = File_Read(hFile, pBuf, FILECAT_BUFSIZE)) > 0 )
		{
			StdIo_Write(pBuf, Size);
		}
		
		/* Close */
		File_Close(hFile);		
	}

	/* obt@J */
	Memory_Free(pBuf);


	return 0;
}


/* end of file */
