/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  shell_main.c
 * @brief %jp{VF}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "shell_local.h"



/* XNvgs */
int Shell_ExecuteScript(C_SHELL *self, const char *pszFileName)
{
	HANDLE	hFile;
	int		iLen;
	
	/* t@CI[v */
	if ( (hFile = File_Open(pszFileName, FILE_OPEN_READ | FILE_OPEN_EXIST | FILE_OPEN_TEXT)) == HANDLE_NULL )
	{
		StdIo_PrintFormat("open error : %s\n", pszFileName);
		return 1;
	}
	
	/* t@Cs */
	while ( (iLen = File_GetString(hFile, self->pszCommanBuf, self->iCommandBufSize)) > 0 )
	{
		/* ̉s폜 */
		if ( self->pszCommanBuf[iLen-1] == '\n' )
		{
			self->pszCommanBuf[iLen-1] = '\0';
		}
		
		/* s */
		if ( self->pszCommanBuf[0] != '\0' && self->pszCommanBuf[0] != '#' )
		{
			Shell_ExecuteCommand(self, self->pszCommanBuf);
		}
	}
	
	/* t@CN[Y */
	File_Close(hFile);
	
	return 0;
}



/* end of file */
