/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  shell.h
 * @brief %jp{VF}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__shell_local_h__
#define __HOS__shell_local_h__


#include "hosaplfw.h"


#define SHELL_MAX_COMMAND		256			/**< ftHg̃R}h */
#define SHELL_MAX_HISTORY		8			/**< ftHg̃qXgL */



/** obNOhWuǗ\ */
typedef struct t_shell_background
{
	struct t_shell_background	*pNext;
	HANDLE						hProcess;
} T_SHELL_BACKGROUND;


/** VFNX */
typedef struct c_shell
{
	int					iCurPos;			/**< J[\̈̕ʒu */
	int					iCurScreenX;		/**< J[\̃XN[Xʒu */
	int					iScreenWidth;		/**< XN[̕ */
	int					iCommandLen;		/**< R}h̕ */

	char				*pszCommanBuf;		/**< R}hCobt@ */
	char				**ppszHistory;		/**< qXgobt@ */
	int					iCommandBufSize;	/**< R}hobt@̃TCY */
	int					iHistoryMax;		/**< qXg̍ő */

	char				ExecSimple;			/**< PsIvV */
	char				ExecTime;			/**< sԌvIvV */

	T_SHELL_BACKGROUND	*pBackGround;		/**< obNOhvZXXg */
} C_SHELL;


#ifdef __cplusplus
extern "C" {
#endif

C_SHELL *Shell_Create(int iCommandBufSize, int iHistoryMax, int iExecSimple, int iExecTime);	/**<  */
void    Shell_Delete(C_SHELL *self);															/**< 폜 */
int     Shell_Interactive(C_SHELL *self);														/**< C^NeBu[h */
int     Shell_ExecuteScript(C_SHELL *self, const char *pszFileName);							/**< XNvgs */
int     Shell_ExecuteCommand(C_SHELL *self, const char *pszCommand);							/**< R}hs */
void	Shell_CheckBackGround(C_SHELL *self);													/**< obNOhŏÎ`FbN */
int     Shell_InputLine(C_SHELL *self, char *pszBuf, int  iBufSize);							/**< PC */
void    Shell_PutChar(C_SHELL *self, int c);													/**< Po */
void    Shell_CurRight(C_SHELL *self);															/**< J[\Eړ */
void    Shell_CurLeft(C_SHELL *self);															/**< J[\ړ */
void    Shell_ReplaceLine(C_SHELL *self, const char *pszNewLine);								/**< Cu */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__shell_local_h__ */


/* end of file */
