/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  lan9000drv.h
 * @brief %jp{LAN9000t@~[pfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "lan9000drv_local.h"



/** RXgN^ */
FILE_ERR Lan9000Drv_Constructor(C_LAN9000DRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, int iIntNum)
{
	FILE_ERR	ErrCode;

	/* eNXRXgN^Ăяo */
	if ( (ErrCode = SyncDrv_Constructor(&self->SyncDrv, pMethods, SYNCDRV_FACTOR_NUM)) != FILE_ERR_OK )
	{
		return ErrCode;
	}
	
	/* oϐ */
	self->iOpenCount = 0;
	
	/* Lan9000Hal  */
	Lan9000Hal_Create(&self->Lan9000Hal, pRegBase);

	/* ~[ebNX */
	self->hMtx = SysMtx_Create(SYSMTX_ATTR_NORMAL);

	/* ݏo^ */
	self->iIntNum = iIntNum;
	self->hIsr = SysIsr_Create(iIntNum, Lan9000Drv_Isr, (VPARAM)self);
	
	return FILE_ERR_OK;
}


/* end of file */
