/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{LAN9000pfoCXhCo}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "lan9000drv_local.h"


/* M */
void Lan9000Drv_Isr(VPARAM Param)
{
	C_LAN9000DRV	*self;
	unsigned short	uhStatus;

	self = (C_LAN9000DRV *)Param;
	
	/* Ԏ擾 */
	uhStatus = Lan9000Hal_GetInterruptStatus(&self->Lan9000Hal);
	
	/* MĂ */
	if ( uhStatus & LAN9000HAL_ISTATUS_RCVINT )
	{
		/* Ǎ݃VOi𔭐 */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_READ);
		uhStatus &= ~LAN9000HAL_IMASK_RCVINT;
	}

	/* M\Ȃ */
	if ( uhStatus & LAN9000HAL_ISTATUS_ALLOCINT )
	{
		/* ݃VOi𔭐 */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_WRITE);
		uhStatus &= ~LAN9000HAL_IMASK_ALLOCINT;
	}
	
	/* ݃}XNXV */
	Lan9000Hal_SetInterruptMask(&self->Lan9000Hal, uhStatus);	
	
	/* ݃NA */
	SysInt_Clear(self->iIntNum);
}


/* end of file */
