/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{LAN9000pfoCXhCo}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "lan9000drv_local.h"


/** %jp{M} */
FILE_SIZE Lan9000Drv_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size)
{
	C_LAN9000DRV	*self;
	C_SYNCFILE		*pFile;
	FILE_SIZE		RecvSize;
	FILE_ERR		ErrCode;
	unsigned short	uhStatus;
		
	/* upper cast */
	self  = (C_LAN9000DRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;
	
	/* ǍݏJn */
	if ( (ErrCode = SyncDrv_StartProcess(&self->SyncDrv, pFile, SYNCDRV_FACTOR_READ)) != FILE_ERR_OK )
	{
		return (FILE_SIZE)ErrCode;
	}
	
	/* Ǎ݃VOiUNA */
	SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_READ);
	
	for ( ; ; )
	{
		/* M */
		SysMtx_Lock(self->hMtx);	/* NeBJZNVɓ */
		RecvSize = Lan9000Hal_Recv(&self->Lan9000Hal, pBuf, Size);
		SysMtx_Unlock(self->hMtx);	/* NeBJZNVo */
		
		/* MłΔ */
		if ( RecvSize != 0 )
		{
			break;
		}

		/* M݂ */
		uhStatus = Lan9000Hal_GetInterruptStatus(&self->Lan9000Hal);
		Lan9000Hal_SetInterruptMask(&self->Lan9000Hal, (uhStatus | LAN9000HAL_IMASK_RCVINT));
		
		/* ubLO[hłȂΔ */
		if ( SyncFile_GetSyncMode(pFile, SYNCDRV_FACTOR_READ) != FILE_SYNCMODE_BLOCKING )
		{
			SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_READ, 0);
			return 0;
		}
				
		/* M҂ */
		SyncFile_WaitSignal(pFile, SYNCDRV_FACTOR_READ);
			
		/* Ǎ݃VOiNAăgC */
		SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_READ);
	}

	/* ǂݏo */
	SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_READ, (VPARAM)0);
	
	return RecvSize;
}


/* end of file */
