/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  lan9118drv.h
 * @brief %jp{SMSC LAN9118V[YpfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__lan9118drv_h__
#define __HOS__lan9118drv_h__


#include "system/sysapi/sysapi.h"
#include "system/file/syncdrv.h"


/* UARThCo䕔 */
typedef struct c_lan9118drv
{
	C_SYNCDRV		SyncDrv;			/* LN^^foCXhCop */

	void			*pRegBase;		/* WX^x[XAhX */
	int				iIntNum;		/* ݔԍ */
	
	int				iOpenCount;		/* I[vJE^ */
	
	SYSEVT_HANDLE	hEvtSend;		/* MCxg */
	SYSEVT_HANDLE	hEvtRecv;		/* MCxg */
	SYSMTX_HANDLE	hMtxSend;		/* Mr~[ebNX */
	SYSMTX_HANDLE	hMtxRecv;		/* Mr~[ebNX */
	
	unsigned char	ubMacAddr[6];	/* MACAhX */
	
} C_LAN9118DRV;



#ifdef __cplusplus
extern "C" {
#endif

void Lan9118Drv_Create(C_LAN9118DRV *self, void *pRegBase, int iIntNum);	/**< RXgN^ */
void Lan9118Drv_Delete(C_DRVOBJ *pDrvObj);									/**< fXgN^ */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__lan9118drv_h__ */


/* end of file */
