/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  lan9118drv_close.c
 * @brief %jp{SMSC LAN9118V[YpfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "lan9118drv_local.h"


/** N[Y */
void Lan9118Drv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj)
{
	C_LAN9118DRV	*self;
	C_CHRFILE		*pFile;
	
	/* upper cast */
	self  = (C_LAN9118DRV *)pDrvObj;
	pFile = (C_CHRFILE *)pFileObj;

	/* N[Y */
	if ( --self->iOpenCount == 0 )
	{
		SysInt_Disable(self->iIntNum);
	}
	
	/* fBXNv^폜 */
	ChrFile_Delete(pFile);	
	SysMem_Free(pFileObj);
}


/* end of file */
