/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  ne2000drv.c
 * @brief %jp{NE2000݊EtherpfoCXhCo}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "ne2000drv_local.h"



/* z֐e[u */
const T_DRVOBJ_METHODS Ne2000Drv_Methods = 
	{
		Ne2000Drv_Delete,
		Ne2000Drv_Open,
		Ne2000Drv_Close,
		Ne2000Drv_IoControl,
		Ne2000Drv_Seek,
		Ne2000Drv_Read,
		Ne2000Drv_Write,
		Ne2000Drv_Flush,
	};


/** RXgN^ */
void Ne2000Drv_Create(C_NE2000DRV *self, void *pRegAddr, int iIntNum)
{
	/* eNXRXgN^Ăяo */
	SyncDrv_Create(&self->SyncDrv, &Ne2000Drv_Methods);

	/* oϐ */
	self->iOpenCount = 0;

	/* Ne2000Hal  */
	Ne2000Hal_Create(&self->Ne2000Hal, pRegAddr);

	/* Cxg */
	self->hEvtRecv = SysEvt_Create(SYSEVT_ATTR_AUTOCLEAR);
	self->hEvtSend = SysEvt_Create(SYSEVT_ATTR_AUTOCLEAR);

	/* ~[ebNX */
	self->hMtx = SysMtx_Create(SYSMTX_ATTR_NORMAL);

	/* ݏo^ */
	SysIsr_Create(iIntNum, Ne2000Drv_Isr, (VPARAM)self);
}


/** fXgN^ */
void Ne2000Drv_Delete(C_DRVOBJ *pDrvObj)
{
	C_NE2000DRV *self;
	
	/* upper cast */
	self = (C_NE2000DRV *)pDrvObj;

	/* IuWFNg폜 */
	SysEvt_Delete(self->hEvtRecv);
	SysEvt_Delete(self->hEvtSend);
	SysMtx_Delete(self->hMtx);
	
	/* eNXfXgN^ */
	SyncDrv_Delete(&self->SyncDrv);
}


/** I[v */
HANDLE Ne2000Drv_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode)
{
	C_NE2000DRV *self;
	C_SYNCFILE	*pFile;
	
	/* upper cast */
	self = (C_NE2000DRV *)pDrvObj;

	/* create file descriptor */
	if ( (pFile = SysMem_Alloc(sizeof(C_SYNCFILE))) == NULL )
	{
		return HANDLE_NULL;
	}
	SyncFile_Create(pFile, &self->SyncDrv, NULL);
	
	
	/* I[v */
	SysMtx_Lock(self->hMtx);
	if ( self->iOpenCount++ == 0 )
	{
		Ne2000Hal_Setup(&self->Ne2000Hal);
	}
	SysMtx_Unlock(self->hMtx);


	return (HANDLE)pFile;
}


/** N[Y */
void Ne2000Drv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj)
{
	C_NE2000DRV *self;
	C_SYNCFILE	*pFile;

	/* upper cast */
	self  = (C_NE2000DRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;
	
	SysMtx_Lock(self->hMtx);
	if ( --self->iOpenCount == 0 )
	{
		Ne2000Hal_Stop(&self->Ne2000Hal);
	}
	SysMtx_Unlock(self->hMtx);


	/* fBXNv^폜 */
	SyncFile_Delete((C_SYNCFILE *)pFile);	
	SysMem_Free(pFile);
}


/** %jp{M} */
FILE_SIZE Ne2000Drv_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size)
{
	C_NE2000DRV 	*self;
	C_SYNCFILE		*pFile;
	unsigned char	*pubBuf;
	int				iRecvSize = 0;
	
	/* upper cast */
	self  = (C_NE2000DRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;

	/* obt@ */
	pubBuf = (unsigned char *)pBuf;

	for ( ; ; )
	{
		SysMtx_Lock(self->hMtx);
		iRecvSize = Ne2000Hal_Recv(&self->Ne2000Hal, pubBuf, Size);
		SysMtx_Unlock(self->hMtx);

		if ( iRecvSize > 0 )
		{
			break;
		}
		
		/* ubLOłȂΔ */
		if ( pFile->cReadMode != FILE_RMODE_BLOCKING )
		{
			break;
		}

		/* MCxg҂ */
		SysEvt_Wait(self->hEvtRecv);
		SysEvt_Clear(self->hEvtRecv);
	}
	
	return iRecvSize;
}


/** %jp{M} */
FILE_SIZE Ne2000Drv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size)
{
	C_NE2000DRV 	*self;
	C_SYNCFILE		*pFile;
	
	/* upper cast */
	self  = (C_NE2000DRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;

	SysMtx_Lock(self->hMtx);
	Size = Ne2000Hal_Send(&self->Ne2000Hal, pData, Size);
	SysMtx_Unlock(self->hMtx);
	
	return Size;
}


/* ݏ */
void Ne2000Drv_Isr(VPARAM Param)
{
	C_NE2000DRV *self;

	self = (C_NE2000DRV *)Param;
}


/* end of file */
