/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  memdrv.h
 * @brief %jp{}bvht@CpfoCXhCo}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "memdrv_local.h"


/* z֐e[u */
static const T_DRVOBJ_METHODS MemDrv_Methods = 
	{
		{ MemDrv_Delete },
		MemDrv_Open,
		MemDrv_Close,
		MemDrv_IoControl,
		MemDrv_Seek,
		MemDrv_Read,
		MemDrv_Write,
		MemDrv_Flush,
		MemDrv_GetInformation,
	};


/** RXgN^ */
void MemDrv_Constructor(C_MEMDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pMemAddr, FILE_POS MemSize, FILE_POS IniSize, int iAttr)
{
	if ( pMethods == NULL )
	{
		pMethods = &MemDrv_Methods;
	}
	
	/* eNXRXgN^Ăяo */
	DrvObj_Constructor(&self->DrvObj, pMethods);
	
	/* oϐ */
	self->iOpenCount = 0;
	self->pubMemAddr = pMemAddr;	/* ̐擪AhX */
	self->MemSize    = MemSize;		/* TCY */
	self->FileSize   = IniSize;		/* t@CƂẴTCY */
	self->iAttr      = iAttr;		/*  */
	
	/* ~[ebNX */
	self->hMtx = SysMtx_Create(SYSMTX_ATTR_NORMAL);
}


/* end of file */
