/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  streampipe.c
 * @brief %jp{Xg[pCv}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "streampipe_local.h"


/** N[Y */
void StreamPipe_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj)
{
	C_STREAMPIPE	*self;
	C_SYNCFILE		*pFile;
	
	/* upper cast */
	self  = (C_STREAMPIPE *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;

	/* N[Y */
	if ( --self->iOpenCount == 0 )
	{
		StreamBuf_Clear(&self->StreamBuf);
	}
	
	/* fBXNv^폜 */
	SyncFile_Delete(pFile);	
}


/* end of file */
