/** 
 * Hyper Operating System  Application Framework
 *
 * @file  jellyuartdrv_close.c
 * @brief %jp{JellyUart N[Y}%en{JellyUart  close}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "jellyuartdrv_local.h"


/** N[Y */
void JellyUartDrv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj)
{
	C_JELLYUARTDRV	*self;
	C_SYNCFILE		*pFile;
	
	/* upper cast */
	self  = (C_JELLYUARTDRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;

	/* N[Y */
	if ( --self->iOpenCount == 0 )
	{
		SysInt_Disable(self->iIntNumRx);
		SysInt_Disable(self->iIntNumTx);
		StreamBuf_Clear(&self->StmBufRecv);
	}
	
	/* fBXNv^폜 */
	SyncFile_Delete((HANDLE)pFile);	
}


/* end of file */
