/** 
 * Hyper Operating System  Application Framework
 *
 * @file  jellyuartdrv_destructor.c
 * @brief %jp{JellyUart fXgN^}%en{JellyUart  destructor}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "jellyuartdrv_local.h"


/** fXgN^ */
void JellyUartDrv_Destructor(C_JELLYUARTDRV *self)
{
	void	*pMem;

	/* ݃T[rX[`폜 */
	SysIsr_Delete(self->hIsrRx);
	SysIsr_Delete(self->hIsrTx);
	
	/* obt@폜 */
	pMem = StreamBuf_RefBufAddr(&self->StmBufRecv);
	StreamBuf_Delete(&self->StmBuf);
	SysMem_Free(pMem);
	
	/* eNXfXgN^ */
	SyncDrv_Destructor(&self->SyncDrv);
}


/* end of file */
