/** 
 * Hyper Operating System  Application Framework
 *
 * @file  jellyuartdrv_isr.c
 * @brief %jp{JellyUart ݃T[rX[`}%en{JellyUart  interrupt service routine}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "jellyuartdrv_local.h"


/* ݏ */
void JellyUartDrv_IsrRx(VPARAM Param)
{
	C_JELLYUARTDRV	*self;
	int			c;
	
	self = (C_JELLYUARTDRV *)Param;
		
	/* M */	
	if ( (JELLYUART_REG_READ(self, JELLYUART_STATUS) & 0x01) )
	{
		/* Mobt@ǂݏo */	
		do
		{
			/* Mobt@ǂݏo */
			c = (int)JELLYUART_REG_READ(self, JELLYUART_DATA);
			StreamBuf_SendChar(&self->StmBufRecv, c);
		} while ( (JELLYUART_REG_READ(self, JELLYUART_STATUS) & 0x01) );
		
		/* Ǎ݃VOi𔭐 */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_READ);
	}
	
	/* ݗvNA */
	SysInt_Clear(self->iIntNumRx);
}



/* ݏ */
void JellyUartDrv_IsrTx(VPARAM Param)
{
	C_JELLYUARTDRV	*self;
	
	self = (C_JELLYUARTDRV *)Param;
	
	/* M */	
	if ( (JELLYUART_REG_READ(self, JELLYUART_STATUS) & 0x02) )
	{
		/* M݋֎~ */
		SysInt_Disable(self->iIntNumTx);
		
		/* ݃VOi𔭐 */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_WRITE);
	}
	
	/* ݗvNA */
	SysInt_Clear(self->iIntNumTx);
}


/* end of file */
