/** 
 * Hyper Operating System  Application Framework
 *
 * @file  jellyuartdrv_close.c
 * @brief %jp{JellyUart N[Y}%en{JellyUart  close}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "jellyuartdrv_local.h"


/** I[v */
HANDLE JellyUartDrv_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode)
{
	C_JELLYUARTDRV	*self;
	HANDLE		hFile;
	
	/* upper cast */
	self = (C_JELLYUARTDRV *)pDrvObj;

	/* create file descriptor */
	if ( (hFile = SyncFile_Create(&self->SyncDrv, iMode)) == HANDLE_NULL )
	{
		return HANDLE_NULL;
	}
	
	/* I[v */
	if ( self->iOpenCount++ == 0 )
	{
		/* M݂ */
		SysInt_Enable(self->iIntNumRx);
	}
	
	return hFile;
}


/* end of file */
